package org.mule.weave.v2.module.javaplain

import org.mule.weave.v2.model.values.FunctionValue
import org.mule.weave.v2.model.values.NativeValueProvider
import org.mule.weave.v2.module.javaplain.function.JavaPlainInvokeFunction

class JavaPlainNativeValueProvider extends NativeValueProvider {

  private val functions: Map[String, FunctionValue] = toMap(Seq(new JavaPlainInvokeFunction()))

  override def name(): String = "javaplain"

  override def getNativeFunction(name: String): Option[FunctionValue] = {
    functions.get(name)
  }
}
