package org.mule.weave.lsp.actions

import org.eclipse.lsp4j.CodeActionParams
import org.mule.weave.lsp.commands.CommandProvider
import org.mule.weave.lsp.project.ProjectKind
import org.mule.weave.lsp.project.components.ContextMetadata
import org.mule.weave.lsp.services.DataWeaveToolingService
import org.mule.weave.v2.editor.WeaveDocumentToolingService

class CodeActions(coreCodeActions: Seq[CodeActionProvider], projectKind: ProjectKind) {
  private lazy val codeActions: Seq[CodeActionProvider] = coreCodeActions ++ projectKind.customCodeActions()

  def actionsFor(params: CodeActionParams, maybeContextMetadata: Option[ContextMetadata]): Seq[CodeActionProvider] = {
    codeActions.filter(_.handles(params, maybeContextMetadata))
  }
}

object CoreWeaveCodeActions {
  
  def codeActions(toolingService: DataWeaveToolingService, commandProvider: CommandProvider): Seq[CodeActionProvider] = {
    Seq(
      new QuickFixAction(toolingService, commandProvider),
      new InsertDocumentationAction(toolingService, commandProvider),
      new InsertWeaveTypeAction(toolingService, commandProvider),
      new RefactorActionProvider(toolingService, commandProvider)
    )
  }
}