package org.mule.weave.lsp.actions

import org.eclipse.lsp4j.CodeAction
import org.eclipse.lsp4j.CodeActionKind
import org.eclipse.lsp4j.CodeActionParams
import org.eclipse.lsp4j.Command
import org.eclipse.lsp4j.Diagnostic
import org.mule.weave.lsp.commands.CommandProvider
import org.mule.weave.lsp.commands.Commands
import org.mule.weave.lsp.project.components.ContextMetadata
import org.mule.weave.lsp.services.DataWeaveToolingService
import org.mule.weave.v2.editor.QuickFix

import java.util
import scala.collection.JavaConverters._

class QuickFixAction(toolingService: DataWeaveToolingService, commandProvider: CommandProvider) extends CodeActionProvider {

  override def doHandles(params: CodeActionParams, maybeContext: Option[ContextMetadata]): Boolean = {
    val only: util.List[String] = params.getContext.getOnly
    (only == null || only.contains(CodeActionKind.QuickFix)) && !params.getContext.getDiagnostics.isEmpty
  }

  override def doActions(params: CodeActionParams, maybeContext: Option[ContextMetadata]): Array[CodeAction] = {
    val uri: String = params.getTextDocument.getUri
    val diagnostics: util.List[Diagnostic] = params.getContext.getDiagnostics
    val documentToolingService = toolingService.openDocument(params.getTextDocument.getUri, maybeContext, withExpectedOutput = true)
    diagnostics.asScala.flatMap(d => {
      val startOffset: Int = documentToolingService.offsetOf(d.getRange.getStart.getLine, d.getRange.getStart.getCharacter)
      val endOffset: Int = documentToolingService.offsetOf(d.getRange.getEnd.getLine, d.getRange.getEnd.getCharacter)
      val errorKind: String = d.getCode.getLeft
      val severity: String = d.getSeverity.name()
      val quickFixes: Array[QuickFix] = toolingService.quickFixesFor(uri, startOffset, endOffset, errorKind, severity, maybeContext)
      quickFixes.map(qf => {
        val codeAction = new CodeAction(qf.name)
        codeAction.setIsPreferred(true)
        codeAction.setKind(CodeActionKind.QuickFix)
        val command = new Command(qf.name, commandProvider.prefixCommandBaseId(Commands.DW_QUICK_FIX), util.Arrays.asList(
          uri, startOffset: java.lang.Integer, endOffset: java.lang.Integer, errorKind, severity, qf.name
        ))
        codeAction.setCommand(command)
        codeAction
      })
    }).toArray
  }
}
