package org.mule.weave.lsp.project.impl.bat

import org.mule.weave.lsp.bat.BatProjectHelper
import org.mule.weave.lsp.project.Project
import org.mule.weave.lsp.project.ProjectKind
import org.mule.weave.lsp.project.ProjectKindContext
import org.mule.weave.lsp.project.ProjectKindDetector
import org.mule.weave.lsp.project.Settings
import org.mule.weave.lsp.project.components
import org.mule.weave.lsp.project.components.BuildManager
import org.mule.weave.lsp.project.components.DefaultSampleDataManager
import org.mule.weave.lsp.project.components.ModuleStructure
import org.mule.weave.lsp.project.components.NoBuildManager
import org.mule.weave.lsp.project.components.ProjectDependencyManager
import org.mule.weave.lsp.project.components.ProjectStructure
import org.mule.weave.lsp.project.components.RootKind
import org.mule.weave.lsp.project.components.RootStructure
import org.mule.weave.lsp.project.components.SampleDataManager
import org.mule.weave.lsp.project.impl.simple.SimpleDependencyManager
import org.mule.weave.lsp.project.impl.simple.WeaveArtifacts
import org.mule.weave.lsp.services.ClientLogger
import org.mule.weave.lsp.utils.EventBus
import org.mule.weave.lsp.utils.WeaveDirectoryUtils

import java.io.File

class BatProjectKind(project: Project, logger: ClientLogger, eventBus: EventBus) extends ProjectKind {

  private val defaultSampleDataManager = new DefaultSampleDataManager(WeaveDirectoryUtils.getDWHome())

  val BAT = "BAT";

  override def name(): String = BAT

  override def structure(): ProjectStructure = {
    val sourceFolder = project.home()
    val mainRoot = RootStructure(RootKind.MAIN, Array(sourceFolder), Array.empty, sourceFolder)
    val modules = Array(ModuleStructure(project.home().getName, Array(mainRoot), Array()))
    components.ProjectStructure(modules)
  }

  override def dependencyManager(): ProjectDependencyManager = {
    new SimpleDependencyManager(project, logger, eventBus, WeaveArtifacts.BAT_MODULES, Seq(Settings.WLANG_VERSION_PROP_NAME, Settings.BAT_VERSION_PROP_NAME))
  }

  override def buildManager(): BuildManager = NoBuildManager

  override def sampleDataManager(): SampleDataManager = defaultSampleDataManager
}

class BatProjectKindDetector extends ProjectKindDetector {
  override def supports(context: ProjectKindContext): Boolean = {
    new File(context.project.home(), "exchange.json").exists() ||
      new File(context.project.home(), "bat.yaml").exists() ||
      new File(context.project.home(), "bat.yml").exists()
  }

  override def createKind(context: ProjectKindContext): ProjectKind = {
    new BatProjectKind(context.project, context.clientLogger, context.eventBus)
  }
}
