/*
 * Decompiled with CFR 0.152.
 */
package org.mule.weave.lsp.commands;

import java.io.File;
import java.io.Serializable;
import java.util.Arrays;
import org.eclipse.lsp4j.ApplyWorkspaceEditParams;
import org.eclipse.lsp4j.Command;
import org.eclipse.lsp4j.CreateFile;
import org.eclipse.lsp4j.ExecuteCommandParams;
import org.eclipse.lsp4j.MessageParams;
import org.eclipse.lsp4j.MessageType;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.ResourceOperation;
import org.eclipse.lsp4j.TextDocumentEdit;
import org.eclipse.lsp4j.TextEdit;
import org.eclipse.lsp4j.VersionedTextDocumentIdentifier;
import org.eclipse.lsp4j.WorkspaceEdit;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.mule.weave.lsp.commands.CommandProvider;
import org.mule.weave.lsp.commands.Commands$;
import org.mule.weave.lsp.commands.CreateUnitTest$;
import org.mule.weave.lsp.commands.WeaveCommand;
import org.mule.weave.lsp.extension.client.OpenTextDocumentParams;
import org.mule.weave.lsp.extension.client.OpenTextDocumentParams$;
import org.mule.weave.lsp.extension.client.WeaveLanguageClient;
import org.mule.weave.lsp.i18n.UserMessages$;
import org.mule.weave.lsp.project.Project;
import org.mule.weave.lsp.project.ProjectKind;
import org.mule.weave.lsp.project.components.ProjectStructure$;
import org.mule.weave.lsp.services.DataWeaveToolingService;
import org.mule.weave.lsp.utils.URLUtils$;
import org.mule.weave.lsp.utils.WeaveDirectoryUtils$;
import org.mule.weave.v2.editor.WeaveDocumentToolingService;
import org.mule.weave.v2.editor.WeaveUnitTestAddition;
import org.mule.weave.v2.parser.ast.AstNode;
import org.mule.weave.v2.parser.location.Position;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.ArrayOps;
import scala.io.BufferedSource;
import scala.io.Source$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005Uh\u0001\u0002\r\u001a\u0001\u0011B\u0001b\f\u0001\u0003\u0002\u0003\u0006I\u0001\r\u0005\tm\u0001\u0011\t\u0011)A\u0005o!Aq\b\u0001B\u0001B\u0003%\u0001\t\u0003\u0005D\u0001\t\u0005\t\u0015!\u0003G\u0011\u0015I\u0005\u0001\"\u0001K\u0011\u0015\u0001\u0006\u0001\"\u0011R\u0011\u0015i\u0006\u0001\"\u0011_\u0011\u0015I\u0007\u0001\"\u0003k\u0011\u001d\t9\u0002\u0001C\u0005\u00033)a!!\n\u0001\u0001\u0005\u001d\u0002bBA\"\u0001\u0011%\u0011Q\t\u0005\b\u0003#\u0002A\u0011BA*\u0011\u001d\tY\u0007\u0001C\u0005\u0003[B\u0011\"!!\u0001#\u0003%I!a!\t\u000f\u0005e\u0005\u0001\"\u0003\u0002\u001c\"9\u0011q\u0015\u0001\u0005\n\u0005%\u0006bBAZ\u0001\u0011%\u0011Q\u0017\u0005\u0007\u0003s\u0003A\u0011I)\t\u000f\u0005m\u0006\u0001\"\u0011\u0002>\u001e9\u0011\u0011Y\r\t\u0002\u0005\rgA\u0002\r\u001a\u0011\u0003\t)\r\u0003\u0004J+\u0011\u0005\u0011q\u0019\u0005\b\u0003\u0013,B\u0011AAf\u00059\u0019%/Z1uKVs\u0017\u000e\u001e+fgRT!AG\u000e\u0002\u0011\r|W.\\1oINT!\u0001H\u000f\u0002\u00071\u001c\bO\u0003\u0002\u001f?\u0005)q/Z1wK*\u0011\u0001%I\u0001\u0005[VdWMC\u0001#\u0003\ry'oZ\u0002\u0001'\r\u0001Qe\u000b\t\u0003M%j\u0011a\n\u0006\u0002Q\u0005)1oY1mC&\u0011!f\n\u0002\u0007\u0003:L(+\u001a4\u0011\u00051jS\"A\r\n\u00059J\"\u0001D,fCZ,7i\\7nC:$\u0017!\u0005<bY&$\u0017\r^5p]N+'O^5dKB\u0011\u0011\u0007N\u0007\u0002e)\u00111gG\u0001\tg\u0016\u0014h/[2fg&\u0011QG\r\u0002\u0018\t\u0006$\u0018mV3bm\u0016$vn\u001c7j]\u001e\u001cVM\u001d<jG\u0016\f1c^3bm\u0016d\u0015M\\4vC\u001e,7\t\\5f]R\u0004\"\u0001O\u001f\u000e\u0003eR!AO\u001e\u0002\r\rd\u0017.\u001a8u\u0015\ta4$A\u0005fqR,gn]5p]&\u0011a(\u000f\u0002\u0014/\u0016\fg/\u001a'b]\u001e,\u0018mZ3DY&,g\u000e^\u0001\faJ|'.Z2u\u0017&tG\r\u0005\u0002B\t6\t!I\u0003\u0002D7\u00059\u0001O]8kK\u000e$\u0018BA#C\u0005-\u0001&o\u001c6fGR\\\u0015N\u001c3\u0011\u0005\u0005;\u0015B\u0001%C\u0005\u001d\u0001&o\u001c6fGR\fa\u0001P5oSRtD#B&M\u001b:{\u0005C\u0001\u0017\u0001\u0011\u0015yS\u00011\u00011\u0011\u00151T\u00011\u00018\u0011\u0015yT\u00011\u0001A\u0011\u0015\u0019U\u00011\u0001G\u0003%\u0019w.\\7b]\u0012LE\rF\u0001S!\t\u0019&L\u0004\u0002U1B\u0011QkJ\u0007\u0002-*\u0011qkI\u0001\u0007yI|w\u000e\u001e \n\u0005e;\u0013A\u0002)sK\u0012,g-\u0003\u0002\\9\n11\u000b\u001e:j]\u001eT!!W\u0014\u0002\u000f\u0015DXmY;uKR\u0011Qe\u0018\u0005\u0006A\u001e\u0001\r!Y\u0001\u0007a\u0006\u0014\u0018-\\:\u0011\u0005\t<W\"A2\u000b\u0005\u0011,\u0017!\u00027taRR'B\u00014\"\u0003\u001d)7\r\\5qg\u0016L!\u0001[2\u0003)\u0015CXmY;uK\u000e{W.\\1oIB\u000b'/Y7t\u00031!wn\u0011:fCR,G+Z:u)!Yg\u000e\u001f>\u0002\n\u0005M\u0001C\u0001\u0014m\u0013\tiwE\u0001\u0003V]&$\b\"B8\t\u0001\u0004\u0001\u0018\u0001\u0003;fgR4\u0015\u000e\\3\u0011\u0005E4X\"\u0001:\u000b\u0005M$\u0018AA5p\u0015\u0005)\u0018\u0001\u00026bm\u0006L!a\u001e:\u0003\t\u0019KG.\u001a\u0005\u0006s\"\u0001\rAU\u0001\fi\u0016\u001cHOR5mKV\u0013F\nC\u0003|\u0011\u0001\u0007A0\u0001\fe_\u000e,X.\u001a8u)>|G.\u001b8h'\u0016\u0014h/[2f!\ri\u0018QA\u0007\u0002}*\u0019q0!\u0001\u0002\r\u0015$\u0017\u000e^8s\u0015\r\t\u0019!H\u0001\u0003mJJ1!a\u0002\u007f\u0005m9V-\u0019<f\t>\u001cW/\\3oiR{w\u000e\\5oON+'O^5dK\"9\u00111\u0002\u0005A\u0002\u00055\u0011aC:uCJ$xJ\u001a4tKR\u00042AJA\b\u0013\r\t\tb\n\u0002\u0004\u0013:$\bbBA\u000b\u0011\u0001\u0007\u0011QB\u0001\nK:$wJ\u001a4tKR\f!#\u00193e)\u0016\u001cH\u000fV8CY\u0006t7NR5mKRY1.a\u0007\u0002\u001e\u0005}\u0011\u0011EA\u0012\u0011\u0015y\u0017\u00021\u0001q\u0011\u0015I\u0018\u00021\u0001S\u0011\u0015Y\u0018\u00021\u0001}\u0011\u001d\tY!\u0003a\u0001\u0003\u001bAq!!\u0006\n\u0001\u0004\tiA\u0001\u0003FI&$\b\u0003CA\u0015\u0003g\t9$!\u0010\u000e\u0005\u0005-\"\u0002BA\u0017\u0003_\t\u0001\"\\3tg\u0006<Wm\u001d\u0006\u0004\u0003c\u0019\u0017a\u00026t_:\u0014\boY\u0005\u0005\u0003k\tYC\u0001\u0004FSRDWM\u001d\t\u0004E\u0006e\u0012bAA\u001eG\n\u0001B+\u001a=u\t>\u001cW/\\3oi\u0016#\u0017\u000e\u001e\t\u0004E\u0006}\u0012bAA!G\n\t\"+Z:pkJ\u001cWm\u00149fe\u0006$\u0018n\u001c8\u00023\u0005$G\rV3tiR{W\t_5ti&tw\rV3ti\u000e{G-\u001a\u000b\fW\u0006\u001d\u0013\u0011JA&\u0003\u001b\ny\u0005C\u0003p\u0017\u0001\u0007\u0001\u000fC\u0003z\u0017\u0001\u0007!\u000bC\u0003|\u0017\u0001\u0007A\u0010C\u0004\u0002\f-\u0001\r!!\u0004\t\u000f\u0005U1\u00021\u0001\u0002\u000e\u0005yq-\u001a;UKN$\u0018\t\u001a3ji&|g\u000e\u0006\u0006\u0002V\u0005\u0005\u0014QMA4\u0003S\u0002RAJA,\u00037J1!!\u0017(\u0005\u0019y\u0005\u000f^5p]B\u0019Q0!\u0018\n\u0007\u0005}cPA\u000bXK\u00064X-\u00168jiR+7\u000f^!eI&$\u0018n\u001c8\t\r\u0005\rD\u00021\u0001}\u0003I!Xm\u001d;U_>d\u0017N\\4TKJ4\u0018nY3\t\u000bmd\u0001\u0019\u0001?\t\u000f\u0005-A\u00021\u0001\u0002\u000e!9\u0011Q\u0003\u0007A\u0002\u00055\u0011AD5og\u0016\u0014H\u000fV3yi\u0016#\u0017\u000e\u001e\u000b\u000b\u0003_\n\u0019(!\u001e\u0002z\u0005u\u0004cAA9\u00155\t\u0001\u0001C\u0003z\u001b\u0001\u0007!\u000b\u0003\u0004\u0002x5\u0001\rAU\u0001\u0005i\u0016\u001cH\u000fC\u0004\u0002|5\u0001\r!!\u0004\u0002\t1Lg.\u001a\u0005\n\u0003\u007fj\u0001\u0013!a\u0001\u0003\u001b\taaY8mk6t\u0017\u0001G5og\u0016\u0014H\u000fV3yi\u0016#\u0017\u000e\u001e\u0013eK\u001a\fW\u000f\u001c;%iU\u0011\u0011Q\u0011\u0016\u0005\u0003\u001b\t9i\u000b\u0002\u0002\nB!\u00111RAK\u001b\t\tiI\u0003\u0003\u0002\u0010\u0006E\u0015!C;oG\",7m[3e\u0015\r\t\u0019jJ\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BAL\u0003\u001b\u0013\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0003)\t\u0007\u000f\u001d7z\u000b\u0012LGo\u001d\u000b\u0004W\u0006u\u0005bBAP\u001f\u0001\u0007\u0011\u0011U\u0001\u0006K\u0012LGo\u001d\t\u0006M\u0005\r\u0016qE\u0005\u0004\u0003K;#A\u0003\u001fsKB,\u0017\r^3e}\u0005Y\u0011n\u001d\"mC:\\g)\u001b7f)\u0011\tY+!-\u0011\u0007\u0019\ni+C\u0002\u00020\u001e\u0012qAQ8pY\u0016\fg\u000eC\u0003p!\u0001\u0007\u0001/A\bv]\u0006\u0014G.\u001a+p%VtG+Z:u)\rY\u0017q\u0017\u0005\u0006_F\u0001\r\u0001]\u0001\u0005]\u0006lW-A\u0006eKN\u001c'/\u001b9uS>tGc\u0001*\u0002@\")\u0001m\u0005a\u0001C\u0006q1I]3bi\u0016,f.\u001b;UKN$\bC\u0001\u0017\u0016'\t)R\u0005\u0006\u0002\u0002D\u0006i1M]3bi\u0016\u001cu.\\7b]\u0012$\u0002\"!4\u0002T\u0006]\u00171\u001e\t\u0004E\u0006=\u0017bAAiG\n91i\\7nC:$\u0007BBAk/\u0001\u0007!+A\u0002ve&Dq!!7\u0018\u0001\u0004\tY.A\u0004bgRtu\u000eZ3\u0011\t\u0005u\u0017q]\u0007\u0003\u0003?TA!!9\u0002d\u0006\u0019\u0011m\u001d;\u000b\t\u0005\u0015\u0018\u0011A\u0001\u0007a\u0006\u00148/\u001a:\n\t\u0005%\u0018q\u001c\u0002\b\u0003N$hj\u001c3f\u0011\u001d\tio\u0006a\u0001\u0003_\fqbY8n[\u0006tG\r\u0015:pm&$WM\u001d\t\u0004Y\u0005E\u0018bAAz3\ty1i\\7nC:$\u0007K]8wS\u0012,'\u000f")
public class CreateUnitTest
implements WeaveCommand {
    private final DataWeaveToolingService validationService;
    private final WeaveLanguageClient weaveLanguageClient;
    private final ProjectKind projectKind;
    private final Project project;

    public static Command createCommand(String string, AstNode astNode, CommandProvider commandProvider) {
        return CreateUnitTest$.MODULE$.createCommand(string, astNode, commandProvider);
    }

    @Override
    public String commandId() {
        return Commands$.MODULE$.DW_CREATE_UNIT_TEST();
    }

    @Override
    public Object execute(ExecuteCommandParams params) {
        java.util.List args = params.getArguments();
        String uri = Commands$.MODULE$.argAsString(args, 0);
        int startOffset = Commands$.MODULE$.argAsInt(args, 1);
        int endOffset = Commands$.MODULE$.argAsInt(args, 2);
        WeaveDocumentToolingService documentToolingService = this.validationService.openDocument(uri, this.validationService.openDocument$default$2());
        String testPath = documentToolingService.getTestPathFromDefinition();
        File[] files = ProjectStructure$.MODULE$.testsSourceFolders(this.projectKind.structure());
        File weaveTestFolder = (File)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])files)).find((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean((boolean)CreateUnitTest.$anonfun$execute$1(f))).getOrElse((Function0 & Serializable & scala.Serializable)() -> $this.projectKind.projectFolderFactory().createTestSourceFolder($this.project));
        File testFile = new File(weaveTestFolder, testPath);
        String testFileURL = URLUtils$.MODULE$.toLSPUrl(testFile);
        this.doCreateTest(testFile, testFileURL, documentToolingService, startOffset, endOffset);
        return null;
    }

    private void doCreateTest(File testFile, String testFileURL, WeaveDocumentToolingService documentToolingService, int startOffset, int endOffset) {
        if (this.isBlankFile(testFile)) {
            this.addTestToBlankFile(testFile, testFileURL, documentToolingService, startOffset, endOffset);
        } else {
            this.addTestToExistingTestCode(testFile, testFileURL, documentToolingService, startOffset, endOffset);
        }
    }

    private void addTestToBlankFile(File testFile, String testFileURL, WeaveDocumentToolingService documentToolingService, int startOffset, int endOffset) {
        Option maybeTest = documentToolingService.createUnitTestFromDefinition(startOffset, endOffset);
        maybeTest.foreach((Function1 & Serializable & scala.Serializable)test -> {
            CreateUnitTest.$anonfun$addTestToBlankFile$1(this, testFileURL, testFile, test);
            return BoxedUnit.UNIT;
        });
    }

    private void addTestToExistingTestCode(File testFile, String testFileURL, WeaveDocumentToolingService documentToolingService, int startOffset, int endOffset) {
        BoxedUnit boxedUnit;
        WeaveDocumentToolingService testToolingService = this.validationService.openDocument(testFileURL, this.validationService.openDocument$default$2());
        Option<WeaveUnitTestAddition> maybeAddition = this.getTestAddition(testToolingService, documentToolingService, startOffset, endOffset);
        if (maybeAddition.isEmpty()) {
            this.unableToRunTest(testFile);
            return;
        }
        WeaveUnitTestAddition testAddition = (WeaveUnitTestAddition)maybeAddition.get();
        String testStr = testAddition.test();
        int line = testAddition.replacementLine() - 1;
        ArrayBuffer edits = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        if (testAddition.needsCommaBefore()) {
            Position commaPosition = testAddition.commaPosition();
            boxedUnit = edits.$plus$eq(this.insertTextEdit(testFileURL, ",", commaPosition.line() - 1, commaPosition.column() - 1));
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        edits.$plus$eq(this.insertTextEdit(testFileURL, testStr, line, this.insertTextEdit$default$4()));
        this.applyEdits((Seq<Either<TextDocumentEdit, ResourceOperation>>)edits);
        this.weaveLanguageClient.openTextDocument(new OpenTextDocumentParams(testFileURL, new Range(new org.eclipse.lsp4j.Position(line, 0), new org.eclipse.lsp4j.Position(line + new StringOps(Predef$.MODULE$.augmentString(testStr)).count((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)CreateUnitTest.$anonfun$addTestToExistingTestCode$1(BoxesRunTime.unboxToChar((Object)x$1)))), 0))));
    }

    private Option<WeaveUnitTestAddition> getTestAddition(WeaveDocumentToolingService testToolingService, WeaveDocumentToolingService documentToolingService, int startOffset, int endOffset) {
        Option maybeAst = testToolingService.ast();
        return maybeAst.flatMap((Function1 & Serializable & scala.Serializable)ast -> documentToolingService.addUnitTestFromDefinition(startOffset, endOffset, ast));
    }

    private Either<TextDocumentEdit, ResourceOperation> insertTextEdit(String testFileURL, String test, int line, int column) {
        org.eclipse.lsp4j.Position position = new org.eclipse.lsp4j.Position(line, column);
        TextEdit textEdit = new TextEdit(new Range(position, position), test);
        TextDocumentEdit textDocumentEdit = new TextDocumentEdit(new VersionedTextDocumentIdentifier(testFileURL, Predef$.MODULE$.int2Integer(0)), Arrays.asList((Object[])new TextEdit[]{textEdit}));
        return Either.forLeft((Object)textDocumentEdit);
    }

    private int insertTextEdit$default$4() {
        return 0;
    }

    private void applyEdits(Seq<Either<TextDocumentEdit, ResourceOperation>> edits) {
        java.util.List<Object> editList = Arrays.asList((Object[])edits.toArray(ClassTag$.MODULE$.apply(Either.class)));
        this.weaveLanguageClient.applyEdit(new ApplyWorkspaceEditParams(new WorkspaceEdit(editList))).get();
    }

    private boolean isBlankFile(File testFile) {
        boolean bl;
        if (!testFile.exists()) {
            bl = true;
        } else {
            try (BufferedSource source = Source$.MODULE$.fromFile(testFile, "UTF-8");){
                bl = source.mkString().trim().isEmpty();
            }
        }
        return bl;
    }

    private void unableToRunTest(File testFile) {
        this.weaveLanguageClient.showMessage(new MessageParams(MessageType.Error, UserMessages$.MODULE$.invalidTestFileSyntax(testFile)));
    }

    @Override
    public String name() {
        return "Creates Unit.";
    }

    @Override
    public String description(ExecuteCommandParams params) {
        return "Creating Unit Test.";
    }

    public static final /* synthetic */ boolean $anonfun$execute$1(File f) {
        String string = f.getName();
        String string2 = WeaveDirectoryUtils$.MODULE$.DWTest_FOLDER();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ void $anonfun$addTestToBlankFile$1(CreateUnitTest $this, String testFileURL$1, File testFile$1, String test) {
        Either<TextDocumentEdit, ResourceOperation> insertText = $this.insertTextEdit(testFileURL$1, test, 0, $this.insertTextEdit$default$4());
        Either createFile = Either.forRight((Object)new CreateFile(testFileURL$1));
        Seq edits = !testFile$1.exists() ? (Seq)new .colon.colon((Object)createFile, (List)new .colon.colon(insertText, (List)Nil$.MODULE$)) : (Seq)new .colon.colon(insertText, (List)Nil$.MODULE$);
        $this.applyEdits((Seq<Either<TextDocumentEdit, ResourceOperation>>)edits);
        $this.weaveLanguageClient.openTextDocument(new OpenTextDocumentParams(testFileURL$1, OpenTextDocumentParams$.MODULE$.apply$default$2()));
    }

    public static final /* synthetic */ boolean $anonfun$addTestToExistingTestCode$1(char x$1) {
        return x$1 == '\n';
    }

    public CreateUnitTest(DataWeaveToolingService validationService, WeaveLanguageClient weaveLanguageClient, ProjectKind projectKind, Project project) {
        this.validationService = validationService;
        this.weaveLanguageClient = weaveLanguageClient;
        this.projectKind = projectKind;
        this.project = project;
        WeaveCommand.$init$(this);
    }
}

