/*
 * Decompiled with CFR 0.152.
 */
package org.mule.weave.lsp.commands;

import java.io.Serializable;
import java.util.concurrent.CountDownLatch;
import org.eclipse.lsp4j.ExecuteCommandParams;
import org.eclipse.lsp4j.MessageParams;
import org.eclipse.lsp4j.MessageType;
import org.mule.weave.dsp.DataWeaveDebuggerAdapterProtocolLauncher$;
import org.mule.weave.lsp.commands.Commands$;
import org.mule.weave.lsp.commands.WeaveCommand;
import org.mule.weave.lsp.extension.client.WeaveLanguageClient;
import org.mule.weave.lsp.jobs.JobManagerService;
import org.mule.weave.lsp.project.Project;
import org.mule.weave.lsp.project.ProjectKind;
import org.mule.weave.lsp.project.components.ProcessLauncher;
import org.mule.weave.lsp.project.components.ProcessLauncher$;
import org.mule.weave.lsp.services.ClientLogger;
import org.mule.weave.lsp.services.DataWeaveTestService;
import org.mule.weave.lsp.utils.NetUtils$;
import org.mule.weave.lsp.vfs.ProjectVirtualFileSystem;
import org.mule.weave.v2.editor.VirtualFileSystem;
import scala.Function0;
import scala.Predef$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005}a\u0001B\b\u0011\u0001mA\u0001B\n\u0001\u0003\u0002\u0003\u0006Ia\n\u0005\t_\u0001\u0011\t\u0011)A\u0005a!Aa\u0007\u0001B\u0001B\u0003%q\u0007\u0003\u0005=\u0001\t\u0005\t\u0015!\u0003>\u0011!\u0001\u0005A!A!\u0002\u0013\t\u0005\u0002C$\u0001\u0005\u0003\u0005\u000b\u0011\u0002%\t\u00119\u0003!\u0011!Q\u0001\n=C\u0001b\u0016\u0001\u0003\u0002\u0003\u0006I\u0001\u0017\u0005\u00067\u0002!\t\u0001\u0018\u0005\u0006M\u0002!\te\u001a\u0005\u0006g\u0002!\t\u0005\u001e\u0005\u0007\u007f\u0002!\t!!\u0001\t\r\u0005]\u0001\u0001\"\u0011h\u0011\u001d\tI\u0002\u0001C!\u00037\u0011qBU;o/\u0016\fg/Z\"p[6\fg\u000e\u001a\u0006\u0003#I\t\u0001bY8n[\u0006tGm\u001d\u0006\u0003'Q\t1\u0001\\:q\u0015\t)b#A\u0003xK\u00064XM\u0003\u0002\u00181\u0005!Q.\u001e7f\u0015\u0005I\u0012aA8sO\u000e\u00011c\u0001\u0001\u001dEA\u0011Q\u0004I\u0007\u0002=)\tq$A\u0003tG\u0006d\u0017-\u0003\u0002\"=\t1\u0011I\\=SK\u001a\u0004\"a\t\u0013\u000e\u0003AI!!\n\t\u0003\u0019]+\u0017M^3D_6l\u0017M\u001c3\u0002#YL'\u000f^;bY\u001aKG.Z*zgR,W\u000e\u0005\u0002)[5\t\u0011F\u0003\u0002+W\u00051Q\rZ5u_JT!\u0001\f\u000b\u0002\u0005Y\u0014\u0014B\u0001\u0018*\u0005E1\u0016N\u001d;vC24\u0015\u000e\\3TsN$X-\\\u0001\u0019aJ|'.Z2u-&\u0014H/^1m\r&dWmU=ti\u0016l\u0007CA\u00195\u001b\u0005\u0011$BA\u001a\u0013\u0003\r1hm]\u0005\u0003kI\u0012\u0001\u0004\u0015:pU\u0016\u001cGOV5siV\fGNR5mKNK8\u000f^3n\u0003\u001d\u0001(o\u001c6fGR\u0004\"\u0001\u000f\u001e\u000e\u0003eR!A\u000e\n\n\u0005mJ$a\u0002)s_*,7\r^\u0001\faJ|'.Z2u\u0017&tG\r\u0005\u00029}%\u0011q(\u000f\u0002\f!J|'.Z2u\u0017&tG-\u0001\u0007dY&,g\u000e\u001e'pO\u001e,'\u000f\u0005\u0002C\u000b6\t1I\u0003\u0002E%\u0005A1/\u001a:wS\u000e,7/\u0003\u0002G\u0007\na1\t\\5f]RdunZ4fe\u0006\t\"n\u001c2NC:\fw-\u001a:TKJ4\u0018nY3\u0011\u0005%cU\"\u0001&\u000b\u0005-\u0013\u0012\u0001\u00026pENL!!\u0014&\u0003#){'-T1oC\u001e,'oU3sm&\u001cW-\u0001\bmC:<W/Y4f\u00072LWM\u001c;\u0011\u0005A+V\"A)\u000b\u0005I\u001b\u0016AB2mS\u0016tGO\u0003\u0002U%\u0005IQ\r\u001f;f]NLwN\\\u0005\u0003-F\u00131cV3bm\u0016d\u0015M\\4vC\u001e,7\t\\5f]R\fA\u0003Z1uC^+\u0017M^3UKN$8+\u001a:wS\u000e,\u0007C\u0001\"Z\u0013\tQ6I\u0001\u000bECR\fw+Z1wKR+7\u000f^*feZL7-Z\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0013usv\fY1cG\u0012,\u0007CA\u0012\u0001\u0011\u00151\u0013\u00021\u0001(\u0011\u0015y\u0013\u00021\u00011\u0011\u00151\u0014\u00021\u00018\u0011\u0015a\u0014\u00021\u0001>\u0011\u0015\u0001\u0015\u00021\u0001B\u0011\u00159\u0015\u00021\u0001I\u0011\u0015q\u0015\u00021\u0001P\u0011\u00159\u0016\u00021\u0001Y\u0003%\u0019w.\\7b]\u0012LE\rF\u0001i!\tI\u0007O\u0004\u0002k]B\u00111NH\u0007\u0002Y*\u0011QNG\u0001\u0007yI|w\u000e\u001e \n\u0005=t\u0012A\u0002)sK\u0012,g-\u0003\u0002re\n11\u000b\u001e:j]\u001eT!a\u001c\u0010\u0002\u000f\u0015DXmY;uKR\u0011A$\u001e\u0005\u0006m.\u0001\ra^\u0001\u0007a\u0006\u0014\u0018-\\:\u0011\u0005alX\"A=\u000b\u0005i\\\u0018!\u00027taRR'B\u0001?\u0019\u0003\u001d)7\r\\5qg\u0016L!A`=\u0003)\u0015CXmY;uK\u000e{W.\\1oIB\u000b'/Y7t\u0003)\u0011XO\\'baBLgn\u001a\u000b\u0005\u0003\u0007\t\u0019\u0002\u0005\u0003\u0002\u0006\u0005=QBAA\u0004\u0015\u0011\tI!a\u0003\u0002\t1\fgn\u001a\u0006\u0003\u0003\u001b\tAA[1wC&!\u0011\u0011CA\u0004\u0005\u001dIe\u000e^3hKJDa!!\u0006\r\u0001\u0004A\u0017AB2p]\u001aLw-\u0001\u0003oC6,\u0017a\u00033fg\u000e\u0014\u0018\u000e\u001d;j_:$2\u0001[A\u000f\u0011\u00151h\u00021\u0001x\u0001")
public class RunWeaveCommand
implements WeaveCommand {
    private final VirtualFileSystem virtualFileSystem;
    private final ProjectVirtualFileSystem projectVirtualFileSystem;
    private final Project project;
    private final ProjectKind projectKind;
    private final ClientLogger clientLogger;
    private final JobManagerService jobManagerService;
    private final WeaveLanguageClient languageClient;
    private final DataWeaveTestService dataWeaveTestService;

    @Override
    public String commandId() {
        return Commands$.MODULE$.DW_RUN_MAPPING();
    }

    @Override
    public Object execute(ExecuteCommandParams params) {
        String configType = Commands$.MODULE$.argAsString(params.getArguments(), 0);
        return this.runMapping(configType);
    }

    public Integer runMapping(String config) {
        Integer n;
        if (!this.project.isStarted()) {
            this.languageClient.showMessage(new MessageParams(MessageType.Warning, "Can not run a DW script until Project was initialized."));
            n = Predef$.MODULE$.int2Integer(-1);
        } else {
            int port = NetUtils$.MODULE$.freePort();
            CountDownLatch latch = new CountDownLatch(1);
            this.jobManagerService.schedule(status -> {
                ProcessLauncher launcher = ProcessLauncher$.MODULE$.createLauncherByType(config, $this.projectKind, $this.clientLogger, $this.languageClient, $this.projectVirtualFileSystem);
                DataWeaveDebuggerAdapterProtocolLauncher$.MODULE$.launch($this.virtualFileSystem, $this.clientLogger, $this.languageClient, launcher, $this.projectKind, $this.jobManagerService, $this.dataWeaveTestService, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> latch.countDown(), port);
            }, "Starting Debugger Server", "Starting Debugger Server");
            latch.await();
            n = Predef$.MODULE$.int2Integer(port);
        }
        return n;
    }

    @Override
    public String name() {
        return "Run DataWeave.";
    }

    @Override
    public String description(ExecuteCommandParams params) {
        return "Running DataWeave Command.";
    }

    public RunWeaveCommand(VirtualFileSystem virtualFileSystem, ProjectVirtualFileSystem projectVirtualFileSystem, Project project, ProjectKind projectKind, ClientLogger clientLogger, JobManagerService jobManagerService, WeaveLanguageClient languageClient, DataWeaveTestService dataWeaveTestService) {
        this.virtualFileSystem = virtualFileSystem;
        this.projectVirtualFileSystem = projectVirtualFileSystem;
        this.project = project;
        this.projectKind = projectKind;
        this.clientLogger = clientLogger;
        this.jobManagerService = jobManagerService;
        this.languageClient = languageClient;
        this.dataWeaveTestService = dataWeaveTestService;
        WeaveCommand.$init$(this);
    }
}

