package org.mule.weave.lsp.bat

import org.eclipse.lsp4j.MessageParams
import org.eclipse.lsp4j.MessageType
import org.eclipse.lsp4j.ShowMessageRequestParams
import org.mule.weave.lsp.utils.Messages.no
import org.mule.weave.lsp.utils.Messages.yes

import scala.collection.JavaConverters.seqAsJavaListConverter

object BatUserMessages {

  def installBatCLI(): ShowMessageRequestParams = {
    val params = new ShowMessageRequestParams()

    params.setMessage("BAT CLI Not Installed. Do you want to install it?")
    params.setType(MessageType.Warning)
    params.setActions(
      List(
        yes,
        no
      ).asJava
    )
    params
  }

  def batCLINotFound() = {
    new MessageParams(MessageType.Error, "Unable to find bat cli")
  }

}
