package org.mule.weave.lsp.commands

import org.eclipse.lsp4j.ExecuteCommandParams
import org.mule.weave.lsp.extension.client.WeaveLanguageClient
import org.mule.weave.lsp.project.ProjectKind

import scala.io.Source

class CreateModuleFileCommand(val project: ProjectKind, val weaveLanguageClient: WeaveLanguageClient) extends AbstractCreateFileCommand {

  val MODULE_TEMPLATE: String = {
    val source = Source.fromInputStream(getClass.getClassLoader.getResourceAsStream("dw-template-module.dwl"), "UTF-8")
    try {
      source.mkString
    } finally {
      source.close()
    }
  }

  override def commandId(): String = Commands.DW_CREATE_MODULE

  def getTemplate(executeCommandParams: ExecuteCommandParams) = {
    MODULE_TEMPLATE.replace("${syntaxVersion}", project.getWeaveVersion())
  }

  def getInputLabel = {
    "Name Of The Module"
  }

  override def name(): String = "Create Module File."

  override def description(params: ExecuteCommandParams): String = "Creating Module file."

  override def getDefaultName(params: ExecuteCommandParams): String = "MyModule.dwl"
}
