package org.mule.weave.lsp.commands
import org.eclipse.lsp4j.ExecuteCommandParams

/**
  * A Weave command wrapper intended to add a prefix before the command id
  *
  * @param prefix
  * @param delegate
  */
case class PrefixedWeaveCommand(prefix: String, delegate: WeaveCommand) extends WeaveCommand {

  override def commandId(): String = prefix ++ delegate.commandId()

  override def name(): String = delegate.name()

  override def description(params: ExecuteCommandParams): String = delegate.description(params)

  override def execute(params: ExecuteCommandParams): AnyRef = delegate.execute(params)
}
