package org.mule.weave.lsp.services

import org.mule.weave.lsp.agent.WeaveAgentService
import org.mule.weave.lsp.extension.client.WeaveLanguageClient
import org.mule.weave.lsp.jobs.JobManagerService
import org.mule.weave.lsp.project.Project

trait PreviewServiceFactory {

  def getPreviewService(agentService: WeaveAgentService, weaveLanguageClient: WeaveLanguageClient, project: Project, toolingServices: DataWeaveToolingService, jobManager: JobManagerService, previewScheme: String): PreviewService

}

class DefaultPreviewServiceFactory extends PreviewServiceFactory {

  def getPreviewService(agentService: WeaveAgentService, weaveLanguageClient: WeaveLanguageClient, project: Project, toolingServices: DataWeaveToolingService, jobManager: JobManagerService, previewScheme: String): PreviewService = {
    new PreviewService(agentService, weaveLanguageClient, project, toolingServices, jobManager, previewScheme)
  }
}
