package org.mule.weave.lsp.services.events

import org.mule.weave.lsp.services.events.ActiveScenarioChangedEvent.ACTIVE_SCENARIO_CHANGED
import org.mule.weave.lsp.utils.Event
import org.mule.weave.lsp.utils.EventHandler
import org.mule.weave.lsp.utils.EventType
import org.mule.weave.v2.editor.VirtualFile

class ActiveScenarioChangedEvent(vf: VirtualFile) extends Event {
  override type T = OnActiveScenarioChanged

  override def getType: EventType[OnActiveScenarioChanged] = ACTIVE_SCENARIO_CHANGED

  override def dispatch(handler: OnActiveScenarioChanged): Unit = {
    handler.onActiveScenarioChanged(vf)
  }
}

trait OnActiveScenarioChanged extends EventHandler {
  def onActiveScenarioChanged(vf: VirtualFile): Unit
}

object ActiveScenarioChangedEvent {
  val ACTIVE_SCENARIO_CHANGED = EventType[OnActiveScenarioChanged]("ACTIVE_SCENARIO_CHANGED")
}
