package org.mule.weave.lsp.vfs.events

import org.mule.weave.lsp.utils.Event
import org.mule.weave.lsp.utils.EventHandler
import org.mule.weave.lsp.utils.EventType
import org.mule.weave.lsp.vfs.events.ProjectVirtualFileChangedEvent.VIRTUAL_FILE_CHANGED
import org.mule.weave.v2.editor.VirtualFile

class ProjectVirtualFileChangedEvent(vf: VirtualFile) extends Event {

  override type T = OnProjectVirtualFileChangedEvent
  
  override def getType: EventType[OnProjectVirtualFileChangedEvent] = VIRTUAL_FILE_CHANGED

  override def dispatch(handler: OnProjectVirtualFileChangedEvent): Unit = {
    handler.onVirtualFileChanged(vf)
  }
}


object ProjectVirtualFileChangedEvent {
  val VIRTUAL_FILE_CHANGED: EventType[OnProjectVirtualFileChangedEvent] = EventType[OnProjectVirtualFileChangedEvent]("VIRTUAL_FILE_CHANGED")
}

trait OnProjectVirtualFileChangedEvent extends EventHandler {
  def onVirtualFileChanged(vf: VirtualFile)
}