package org.mule.weave.lsp.project.impl.maven

import org.jboss.shrinkwrap.resolver.api.maven.embedded.EmbeddedMaven
import org.mule.weave.lsp.jobs.JobManagerService
import org.mule.weave.lsp.jobs.Status
import org.mule.weave.lsp.project.components.BuildManager
import org.mule.weave.lsp.services.ClientLogger
import org.mule.weave.lsp.utils.LoggerOutputStream

import collection.JavaConverters._
import java.io.File

class MavenBuildManager(pom: File, clientLogger: ClientLogger, jobService: JobManagerService) extends BuildManager {

  override def build(): Unit = {
    executeGoals("clean","compile")
  }

  override def deploy(): Unit = {
    executeGoals("clean","deploy")
  }

  override def buildWithTests(): Unit = {
    executeGoals("clean","test-compile")
  }

  private def executeGoals(goals: String*): Unit ={
    val tasks = goals.mkString(",")
    jobService.execute((_: Status) => {
      LoggerOutputStream.interceptStdOut(clientLogger) {
        val builder = EmbeddedMaven.forProject(pom)
        val maybeMavenHome = MavenBinaryDistributionInstaller(clientLogger).mavenHome()
        if (maybeMavenHome.isDefined) {
          val mavenHome = maybeMavenHome.get
          builder.useInstallation(mavenHome)
        } else {
          builder.useDefaultDistribution()
        }
        builder.setDebug(true)
          .setLogger(new LSPMavenLogger(clientLogger))
          .setBatchMode(true)
          .setGoals(goals.asJava)
          .build()
      }
      return
    },"[Maven Task]" + tasks, "Executing maven tasks: "+ tasks)
  }
}
