package org.mule.weave.lsp.project.impl.maven

import org.jboss.shrinkwrap.resolver.api.maven.Maven
import org.jboss.shrinkwrap.resolver.api.maven.MavenFormatStage
import org.jboss.shrinkwrap.resolver.api.maven.MavenResolvedArtifact
import org.jboss.shrinkwrap.resolver.api.maven.MavenWorkingSession
import org.jboss.shrinkwrap.resolver.api.maven.ScopeType
import org.jboss.shrinkwrap.resolver.api.maven.coordinate.MavenDependency
import org.jboss.shrinkwrap.resolver.impl.maven.MavenStrategyStageImpl

import java.io.File
import java.util
import java.util.Collections
import scala.collection.immutable
import scala.collection.JavaConverters._

class MavenDependencyResolver(pomFile: File) {
  
  val workOffline: Boolean = java.lang.Boolean.getBoolean("maven.work.offline")
  
  def resolve(): java.util.List[MavenResolvedArtifact] = {
    val stage: MavenStrategyStageImpl = Maven.configureResolver()
      .workOffline(workOffline)
      .loadPomFromFile(pomFile)
      // Import All Scopes until Test and Runtime
      .importDependencies(ScopeType.COMPILE, ScopeType.PROVIDED, ScopeType.RUNTIME, ScopeType.TEST)
      .resolve().asInstanceOf[MavenStrategyStageImpl]
    val mavenWorkingSession: MavenWorkingSession = stage.getMavenWorkingSession

    val resolution: util.List[MavenDependency] = mavenWorkingSession.getDependenciesForResolution
    if (resolution != null && !resolution.isEmpty) {
      val mavenFormatStage: MavenFormatStage = stage.withTransitivity()
      val dependencies = mavenFormatStage
          .asResolvedArtifact()
          .groupBy(_.getCoordinate.toCanonicalForm)
          .map(_._2.head)
      dependencies.toList.asJava
    } else {
      Collections.emptyList()
    }
  }
}

object MavenDependencyResolver {
  def apply(pomFile: File): MavenDependencyResolver = new MavenDependencyResolver(pomFile)
}
