package org.mule.weave.lsp.services.events

import org.mule.weave.lsp.services.events.AgentStoppedEvent.AGENT_STOPPED
import org.mule.weave.lsp.utils.Event
import org.mule.weave.lsp.utils.EventHandler
import org.mule.weave.lsp.utils.EventType

class AgentStoppedEvent() extends Event {
  override type T = OnAgentStopped

  override def getType: EventType[OnAgentStopped] = AGENT_STOPPED

  override def dispatch(handler: OnAgentStopped): Unit = {
    handler.onAgentStopped()
  }
}

trait OnAgentStopped extends EventHandler {
  def onAgentStopped(): Unit
}

object AgentStoppedEvent {
  val AGENT_STOPPED = EventType[OnAgentStopped]("AGENT_STOPPED")
}