package org.mule.weave.lsp.vfs.events

import org.mule.weave.lsp.utils.Event
import org.mule.weave.lsp.utils.EventHandler
import org.mule.weave.lsp.utils.EventType
import org.mule.weave.lsp.vfs.events.ProjectVirtualFileDeletedEvent.VIRTUAL_FILE_DELETED
import org.mule.weave.v2.editor.VirtualFile

class ProjectVirtualFileDeletedEvent(vf: VirtualFile) extends Event {

  override type T = OnProjectVirtualFileDeletedEvent
  
  override def getType: EventType[OnProjectVirtualFileDeletedEvent] = VIRTUAL_FILE_DELETED

  override def dispatch(handler: OnProjectVirtualFileDeletedEvent): Unit = {
    handler.onVirtualFileDeleted(vf)
  }
}


object ProjectVirtualFileDeletedEvent {
  val VIRTUAL_FILE_DELETED: EventType[OnProjectVirtualFileDeletedEvent] = EventType[OnProjectVirtualFileDeletedEvent]("VIRTUAL_FILE_DELETED")
}

trait OnProjectVirtualFileDeletedEvent extends EventHandler {
  def onVirtualFileDeleted(vf: VirtualFile)
}