/*
 * Decompiled with CFR 0.152.
 */
package org.mule.weave.lsp.services;

import java.io.File;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.DiagnosticSeverity;
import org.eclipse.lsp4j.PublishDiagnosticsParams;
import org.eclipse.lsp4j.services.LanguageClient;
import org.mule.weave.lsp.indexer.events.IndexingFinishedEvent$;
import org.mule.weave.lsp.indexer.events.IndexingType$;
import org.mule.weave.lsp.indexer.events.OnIndexingFinished;
import org.mule.weave.lsp.project.Project;
import org.mule.weave.lsp.project.ProjectKind;
import org.mule.weave.lsp.project.Settings$;
import org.mule.weave.lsp.project.components.ContextMetadata;
import org.mule.weave.lsp.project.components.SampleDataManager;
import org.mule.weave.lsp.project.events.OnProjectStarted;
import org.mule.weave.lsp.project.events.OnSettingsChanged;
import org.mule.weave.lsp.project.events.ProjectStartedEvent$;
import org.mule.weave.lsp.project.events.SettingsChangedEvent$;
import org.mule.weave.lsp.services.DataWeaveToolingService$;
import org.mule.weave.lsp.services.ToolingService;
import org.mule.weave.lsp.utils.EventBus;
import org.mule.weave.lsp.utils.LSPConverters$;
import org.mule.weave.lsp.utils.URLUtils$;
import org.mule.weave.lsp.utils.WeaveTypeUtils$;
import org.mule.weave.lsp.vfs.events.OnProjectVirtualFileChangedEvent;
import org.mule.weave.lsp.vfs.events.OnProjectVirtualFileCreatedEvent;
import org.mule.weave.lsp.vfs.events.OnProjectVirtualFileDeletedEvent;
import org.mule.weave.lsp.vfs.events.ProjectVirtualFileChangedEvent$;
import org.mule.weave.lsp.vfs.events.ProjectVirtualFileCreatedEvent$;
import org.mule.weave.lsp.vfs.events.ProjectVirtualFileDeletedEvent$;
import org.mule.weave.v2.editor.ImplicitInput$;
import org.mule.weave.v2.editor.MappingInput;
import org.mule.weave.v2.editor.QuickFix;
import org.mule.weave.v2.editor.ValidationMessage;
import org.mule.weave.v2.editor.ValidationMessages;
import org.mule.weave.v2.editor.VirtualFile;
import org.mule.weave.v2.editor.VirtualFileSystem;
import org.mule.weave.v2.editor.WeaveDocumentToolingService;
import org.mule.weave.v2.editor.WeaveToolingService;
import org.mule.weave.v2.parser.ast.variables.NameIdentifier;
import org.mule.weave.v2.sdk.WeaveResource;
import org.mule.weave.v2.ts.WeaveType;
import org.mule.weave.v2.versioncheck.SVersion$;
import scala.Array$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\t]f\u0001B\u0017/\u0001eB\u0001\u0002\u0012\u0001\u0003\u0006\u0004%\t!\u0012\u0005\t\u0017\u0002\u0011\t\u0011)A\u0005\r\"AA\n\u0001B\u0001B\u0003%Q\n\u0003\u0005W\u0001\t\u0015\r\u0011\"\u0001X\u0011!\u0001\u0007A!A!\u0002\u0013A\u0006\u0002C1\u0001\u0005\u0003\u0005\u000b\u0011\u00022\t\u0011!\u0004!\u0011!Q\u0001\n%DQa\u001d\u0001\u0005\u0002QDqa\u001f\u0001C\u0002\u0013%A\u0010C\u0004\u0002\b\u0001\u0001\u000b\u0011B?\t\u0017\u0005%\u0001\u00011AA\u0002\u0013E\u00111\u0002\u0005\f\u0003'\u0001\u0001\u0019!a\u0001\n#\t)\u0002C\u0006\u0002\"\u0001\u0001\r\u0011!Q!\n\u00055\u0001BCA\u0012\u0001!\u0015\r\u0011\"\u0003\u0002&!I\u0011q\u0005\u0001A\u0002\u0013E\u0011\u0011\u0006\u0005\n\u0003c\u0001\u0001\u0019!C\t\u0003gA\u0001\"a\u000e\u0001A\u0003&\u00111\u0006\u0005\b\u0003\u0003\u0002A\u0011IA\"\u0011\u001d\t9\u0006\u0001C\u0005\u00033Bq!!!\u0001\t\u0013\t\u0019\tC\u0004\u0002\n\u0002!I!a#\t\u000f\u0005M\u0005\u0001\"\u0001\u0002\u0016\"9\u0011\u0011\u0016\u0001\u0005\n\u0005-\u0006bBAW\u0001\u0011\u0005\u0011q\u0016\u0005\b\u0003\u0003\u0004A\u0011AAb\u0011%\tI\u000eAI\u0001\n\u0003\tY\u000eC\u0004\u0002r\u0002!\t!a=\t\u0013\u0005}\b!%A\u0005\u0002\u0005m\u0007bBAy\u0001\u0011\u0005!\u0011\u0001\u0005\b\u0005\u0017\u0001A\u0011\u0001B\u0007\u0011\u001d\t\t\u0010\u0001C\u0005\u0005#AqA!\u0007\u0001\t\u0003\u0011Y\u0002C\u0004\u0003 \u0001!\tA!\t\t\u000f\t\u001d\u0002\u0001\"\u0001\u0003*!9!q\u0006\u0001\u0005\u0002\tE\u0002\"\u0003B \u0001E\u0005I\u0011\u0001B!\u0011\u001d\u0011)\u0005\u0001C\u0001\u0005\u000fBqAa\u0019\u0001\t\u0003\u0011)\u0007C\u0005\u0003\u000e\u0002\t\n\u0011\"\u0001\u0003\u0010\"9!1\u0013\u0001\u0005\n\tU\u0005b\u0002BT\u0001\u0011\u0005!\u0011\u0016\u0005\n\u0005_\u0003\u0011\u0013!C\u0001\u0005\u001fCa\u0001\u0014\u0001\u0005\u0002\tE\u0006b\u0002BZ\u0001\u0011\u0005!Q\u0017\u0002\u0018\t\u0006$\u0018mV3bm\u0016$vn\u001c7j]\u001e\u001cVM\u001d<jG\u0016T!a\f\u0019\u0002\u0011M,'O^5dKNT!!\r\u001a\u0002\u00071\u001c\bO\u0003\u00024i\u0005)q/Z1wK*\u0011QGN\u0001\u0005[VdWMC\u00018\u0003\ry'oZ\u0002\u0001'\r\u0001!\b\u0011\t\u0003wyj\u0011\u0001\u0010\u0006\u0002{\u0005)1oY1mC&\u0011q\b\u0010\u0002\u0007\u0003:L(+\u001a4\u0011\u0005\u0005\u0013U\"\u0001\u0018\n\u0005\rs#A\u0004+p_2LgnZ*feZL7-Z\u0001\baJ|'.Z2u+\u00051\u0005CA$J\u001b\u0005A%B\u0001#1\u0013\tQ\u0005JA\u0004Qe>TWm\u0019;\u0002\u0011A\u0014xN[3di\u0002\na\u0002\\1oOV\fw-Z\"mS\u0016tG\u000f\u0005\u0002O)6\tqJ\u0003\u00020!*\u0011\u0011KU\u0001\u0006YN\u0004HG\u001b\u0006\u0003'Z\nq!Z2mSB\u001cX-\u0003\u0002V\u001f\nqA*\u00198hk\u0006<Wm\u00117jK:$\u0018a\u0001<ggV\t\u0001\f\u0005\u0002Z=6\t!L\u0003\u0002\\9\u00061Q\rZ5u_JT!!\u0018\u001a\u0002\u0005Y\u0014\u0014BA0[\u0005E1\u0016N\u001d;vC24\u0015\u000e\\3TsN$X-\\\u0001\u0005m\u001a\u001c\b%\u0001\fe_\u000e,X.\u001a8u'\u0016\u0014h/[2f\r\u0006\u001cGo\u001c:z!\rY4-Z\u0005\u0003Ir\u0012\u0011BR;oGRLwN\u001c\u0019\u0011\u0005e3\u0017BA4[\u0005M9V-\u0019<f)>|G.\u001b8h'\u0016\u0014h/[2f\u0003!)\u00070Z2vi>\u0014\bC\u00016r\u001b\u0005Y'B\u00017n\u0003)\u0019wN\\2veJ,g\u000e\u001e\u0006\u0003]>\fA!\u001e;jY*\t\u0001/\u0001\u0003kCZ\f\u0017B\u0001:l\u0005!)\u00050Z2vi>\u0014\u0018A\u0002\u001fj]&$h\b\u0006\u0004vm^D\u0018P\u001f\t\u0003\u0003\u0002AQ\u0001\u0012\u0005A\u0002\u0019CQ\u0001\u0014\u0005A\u00025CQA\u0016\u0005A\u0002aCQ!\u0019\u0005A\u0002\tDQ\u0001\u001b\u0005A\u0002%\fa\u0001\\8hO\u0016\u0014X#A?\u0011\u0007y\f\u0019!D\u0001\u0000\u0015\r\t\t!\\\u0001\bY><w-\u001b8h\u0013\r\t)a \u0002\u0007\u0019><w-\u001a:\u0002\u000f1|wmZ3sA\u0005Y\u0001O]8kK\u000e$8*\u001b8e+\t\ti\u0001E\u0002H\u0003\u001fI1!!\u0005I\u0005-\u0001&o\u001c6fGR\\\u0015N\u001c3\u0002\u001fA\u0014xN[3di.Kg\u000eZ0%KF$B!a\u0006\u0002\u001eA\u00191(!\u0007\n\u0007\u0005mAH\u0001\u0003V]&$\b\"CA\u0010\u0019\u0005\u0005\t\u0019AA\u0007\u0003\rAH%M\u0001\raJ|'.Z2u\u0017&tG\rI\u0001\u0011?\u0012|7-^7f]R\u001cVM\u001d<jG\u0016,\u0012!Z\u0001\bS:$W\r_3e+\t\tY\u0003E\u0002<\u0003[I1!a\f=\u0005\u001d\u0011un\u001c7fC:\f1\"\u001b8eKb,Gm\u0018\u0013fcR!\u0011qCA\u001b\u0011%\ty\u0002EA\u0001\u0002\u0004\tY#\u0001\u0005j]\u0012,\u00070\u001a3!Q\r\t\u00121\b\t\u0004w\u0005u\u0012bAA y\tAao\u001c7bi&dW-\u0001\u0003j]&$HCBA\f\u0003\u000b\n9\u0005C\u0004\u0002\nI\u0001\r!!\u0004\t\u000f\u0005%#\u00031\u0001\u0002L\u0005AQM^3oi\n+8\u000f\u0005\u0003\u0002N\u0005MSBAA(\u0015\r\t\t\u0006M\u0001\u0006kRLGn]\u0005\u0005\u0003+\nyE\u0001\u0005Fm\u0016tGOQ;t\u0003]1\u0017N\u001c3D_J\u0014Xm\u001d9p]\u0012Lgn\u001a#x\r&dW\r\u0006\u0003\u0002\\\u0005\u001d\u0004#B\u001e\u0002^\u0005\u0005\u0014bAA0y\t1q\n\u001d;j_:\u00042!WA2\u0013\r\t)G\u0017\u0002\f-&\u0014H/^1m\r&dW\rC\u0004\u0002jM\u0001\r!a\u001b\u0002\u0007M$(\u000f\u0005\u0003\u0002n\u0005md\u0002BA8\u0003o\u00022!!\u001d=\u001b\t\t\u0019HC\u0002\u0002va\na\u0001\u0010:p_Rt\u0014bAA=y\u00051\u0001K]3eK\u001aLA!! \u0002\u0000\t11\u000b\u001e:j]\u001eT1!!\u001f=\u0003I1\u0018\r\\5eCR,\u0017\t\u001c7FI&$xN]:\u0015\t\u0005]\u0011Q\u0011\u0005\b\u0003\u000f#\u0002\u0019AA6\u0003\u0019\u0011X-Y:p]\u0006!b/\u00197jI\u0006$X\rR3qK:$WM\\2jKN$b!a\u0006\u0002\u000e\u0006E\u0005bBAH+\u0001\u0007\u0011\u0011M\u0001\u0003m\u001aDq!a\"\u0016\u0001\u0004\tY'\u0001\u0005m_\u0006$G+\u001f9f)\u0011\t9*!*\u0011\u000bm\ni&!'\u0011\t\u0005m\u0015\u0011U\u0007\u0003\u0003;S1!a(]\u0003\t!8/\u0003\u0003\u0002$\u0006u%!C,fCZ,G+\u001f9f\u0011\u001d\t9K\u0006a\u0001\u0003W\n!\u0002^=qKN#(/\u001b8h\u0003=!wnY;nK:$8+\u001a:wS\u000e,G#A3\u0002\u000f%t\u0007/\u001e;PMR1\u0011\u0011WA]\u0003{\u0003RaOA/\u0003g\u00032!WA[\u0013\r\t9L\u0017\u0002\r\u001b\u0006\u0004\b/\u001b8h\u0013:\u0004X\u000f\u001e\u0005\b\u0003wC\u0002\u0019AA6\u0003\r)(/\u001b\u0005\b\u0003\u007fC\u0002\u0019AA6\u0003%Ig\u000e];u\u001d\u0006lW-\u0001\nd_:$X\r\u001f;NKR\fG-\u0019;b\r>\u0014HCBAc\u0003'\f)\u000eE\u0003<\u0003;\n9\r\u0005\u0003\u0002J\u0006=WBAAf\u0015\r\ti\rS\u0001\u000bG>l\u0007o\u001c8f]R\u001c\u0018\u0002BAi\u0003\u0017\u0014qbQ8oi\u0016DH/T3uC\u0012\fG/\u0019\u0005\b\u0003wK\u0002\u0019AA6\u0011%\t9.\u0007I\u0001\u0002\u0004\tY#\u0001\nxSRDW\t\u001f9fGR,GmT;uaV$\u0018\u0001H2p]R,\u0007\u0010^'fi\u0006$\u0017\r^1G_J$C-\u001a4bk2$HEM\u000b\u0003\u0003;TC!a\u000b\u0002`.\u0012\u0011\u0011\u001d\t\u0005\u0003G\fi/\u0004\u0002\u0002f*!\u0011q]Au\u0003%)hn\u00195fG.,GMC\u0002\u0002lr\n!\"\u00198o_R\fG/[8o\u0013\u0011\ty/!:\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\u0007pa\u0016tGi\\2v[\u0016tG\u000f\u0006\u0004\u0002v\u0006m\u0018Q \t\u00043\u0006]\u0018bAA}5\nYr+Z1wK\u0012{7-^7f]R$vn\u001c7j]\u001e\u001cVM\u001d<jG\u0016Dq!a/\u001c\u0001\u0004\tY\u0007C\u0005\u0002Xn\u0001\n\u00111\u0001\u0002,\u00051r\u000e]3o\t>\u001cW/\\3oi\u0012\"WMZ1vYR$#\u0007\u0006\u0005\u0002v\n\r!Q\u0001B\u0005\u0011\u001d\tY,\ba\u0001\u0003WBqAa\u0002\u001e\u0001\u0004\t)-\u0001\u0007nCf\u0014WmQ8oi\u0016DH\u000fC\u0004\u0002Xv\u0001\r!a\u000b\u00025=\u0004XM\u001c#pGVlWM\u001c;XSRDw.\u001e;D_:$X\r\u001f;\u0015\t\u0005U(q\u0002\u0005\b\u0003ws\u0002\u0019AA6)\u0019\t)Pa\u0005\u0003\u0016!9\u00111X\u0010A\u0002\u0005-\u0004b\u0002B\f?\u0001\u0007\u0011qY\u0001\u0010G>tG/\u001a=u\u001b\u0016$\u0018\rZ1uC\u0006i1\r\\8tK\u0012{7-^7f]R$B!a\u0006\u0003\u001e!9\u00111\u0018\u0011A\u0002\u0005-\u0014!E<ji\"d\u0015M\\4vC\u001e,G*\u001a<fYR\u0019QMa\t\t\u000f\t\u0015\u0012\u00051\u0001\u0002l\u0005yAm\u001e'b]\u001e,\u0018mZ3MKZ,G.\u0001\u0007wC2LG-\u0019;f\r&dW\r\u0006\u0004\u0002\u0018\t-\"Q\u0006\u0005\b\u0003\u001f\u0013\u0003\u0019AA1\u0011\u001d\t9I\ta\u0001\u0003W\n\u0011\u0003\u001e:jO\u001e,'OV1mS\u0012\fG/[8o)!\t9Ba\r\u00038\te\u0002b\u0002B\u001bG\u0001\u0007\u00111N\u0001\fI>\u001cW/\\3oiV\u0013\u0018\u000eC\u0004\u0002\b\u000e\u0002\r!a\u001b\t\u0013\tm2\u0005%AA\u0002\tu\u0012AE8o-\u0006d\u0017\u000eZ1uS>tg)\u001b8jg\"\u0004BaO2\u0002\u0018\u0005YBO]5hO\u0016\u0014h+\u00197jI\u0006$\u0018n\u001c8%I\u00164\u0017-\u001e7uIM*\"Aa\u0011+\t\tu\u0012q\\\u0001\u000ei>$\u0015.Y4o_N$\u0018nY:\u0015\t\t%#\u0011\f\t\u0007\u0005\u0017\u0012iE!\u0015\u000e\u00035L1Aa\u0014n\u0005\u0011a\u0015n\u001d;\u0011\t\tM#QK\u0007\u0002!&\u0019!q\u000b)\u0003\u0015\u0011K\u0017m\u001a8pgRL7\rC\u0004\u0003\\\u0015\u0002\rA!\u0018\u0002\u00115,7o]1hKN\u00042!\u0017B0\u0013\r\u0011\tG\u0017\u0002\u0013-\u0006d\u0017\u000eZ1uS>tW*Z:tC\u001e,7/A\u0007rk&\u001c7NR5yKN4uN\u001d\u000b\u000f\u0005O\u0012\u0019H!\u001e\u0003\u0000\t\r%q\u0011BF!\u0015Y$\u0011\u000eB7\u0013\r\u0011Y\u0007\u0010\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u00043\n=\u0014b\u0001B95\nA\u0011+^5dW\u001aK\u0007\u0010C\u0004\u00036\u0019\u0002\r!a\u001b\t\u000f\t]d\u00051\u0001\u0003z\u0005Y1\u000f^1si>3gm]3u!\rY$1P\u0005\u0004\u0005{b$aA%oi\"9!\u0011\u0011\u0014A\u0002\te\u0014!C3oI>3gm]3u\u0011\u001d\u0011)I\na\u0001\u0003W\nAa[5oI\"9!\u0011\u0012\u0014A\u0002\u0005-\u0014\u0001C:fm\u0016\u0014\u0018\u000e^=\t\u0013\t\u001da\u0005%AA\u0002\u0005\u0015\u0017aF9vS\u000e\\g)\u001b=fg\u001a{'\u000f\n3fM\u0006,H\u000e\u001e\u00137+\t\u0011\tJ\u000b\u0003\u0002F\u0006}\u0017AD7bi\u000eDWm]'fgN\fw-\u001a\u000b\u000b\u0003W\u00119J!)\u0003$\n\u0015\u0006b\u0002BMQ\u0001\u0007!1T\u0001\u0002[B\u0019\u0011L!(\n\u0007\t}%LA\tWC2LG-\u0019;j_:lUm]:bO\u0016DqA!\")\u0001\u0004\tY\u0007C\u0004\u0003x!\u0002\rA!\u001f\t\u000f\t\u0005\u0005\u00061\u0001\u0003z\u0005Aa/\u00197jI\u0006$X\r\u0006\u0004\u0003^\t-&Q\u0016\u0005\b\u0005kI\u0003\u0019AA6\u0011%\u00119!\u000bI\u0001\u0002\u0004\t)-\u0001\nwC2LG-\u0019;fI\u0011,g-Y;mi\u0012\u0012D#A'\u0002\u0013\u001d,G\u000fT8hO\u0016\u0014H#A?")
public class DataWeaveToolingService
implements ToolingService {
    private WeaveToolingService _documentService;
    private final Project project;
    private final LanguageClient languageClient;
    private final VirtualFileSystem vfs;
    private Function0<WeaveToolingService> documentServiceFactory;
    private final Executor executor;
    private final Logger logger;
    private ProjectKind projectKind;
    private volatile boolean indexed;
    private volatile boolean bitmap$0;

    public Project project() {
        return this.project;
    }

    public VirtualFileSystem vfs() {
        return this.vfs;
    }

    private Logger logger() {
        return this.logger;
    }

    public ProjectKind projectKind() {
        return this.projectKind;
    }

    public void projectKind_$eq(ProjectKind x$1) {
        this.projectKind = x$1;
    }

    private WeaveToolingService _documentService$lzycompute() {
        DataWeaveToolingService dataWeaveToolingService = this;
        synchronized (dataWeaveToolingService) {
            if (!this.bitmap$0) {
                this._documentService = (WeaveToolingService)this.documentServiceFactory.apply();
                this.bitmap$0 = true;
            }
        }
        this.documentServiceFactory = null;
        return this._documentService;
    }

    private WeaveToolingService _documentService() {
        return !this.bitmap$0 ? this._documentService$lzycompute() : this._documentService;
    }

    public boolean indexed() {
        return this.indexed;
    }

    public void indexed_$eq(boolean x$1) {
        this.indexed = x$1;
    }

    @Override
    public void init(ProjectKind projectKind, EventBus eventBus) {
        this.projectKind_$eq(projectKind);
        eventBus.register(SettingsChangedEvent$.MODULE$.SETTINGS_CHANGED(), new OnSettingsChanged(this){
            private final /* synthetic */ DataWeaveToolingService $outer;

            public void onSettingsChanged(String[] modifiedSettingsName) {
                block0: {
                    if (!new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])modifiedSettingsName)).contains((Object)Settings$.MODULE$.LANGUAGE_LEVEL_PROP_NAME())) break block0;
                    this.$outer.org$mule$weave$lsp$services$DataWeaveToolingService$$validateAllEditors("settingsChanged");
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        eventBus.register(IndexingFinishedEvent$.MODULE$.INDEXING_FINISHED(), new OnIndexingFinished(this){
            private final /* synthetic */ DataWeaveToolingService $outer;

            public void onIndexingFinished(Enumeration.Value indexingType) {
                block0: {
                    if (!IndexingType$.MODULE$.Dependencies().equals((Object)indexingType)) break block0;
                    this.$outer.indexed_$eq(true);
                    this.$outer.org$mule$weave$lsp$services$DataWeaveToolingService$$validateAllEditors("indexingFinishes");
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        eventBus.register(ProjectStartedEvent$.MODULE$.PROJECT_STARTED(), new OnProjectStarted(this){
            private final /* synthetic */ DataWeaveToolingService $outer;

            public void onProjectStarted(Project project) {
                this.$outer.org$mule$weave$lsp$services$DataWeaveToolingService$$validateAllEditors("projectStarted");
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        eventBus.register(ProjectVirtualFileCreatedEvent$.MODULE$.VIRTUAL_FILE_CREATED(), new OnProjectVirtualFileCreatedEvent(this, projectKind){
            private final /* synthetic */ DataWeaveToolingService $outer;
            private final ProjectKind projectKind$1;

            public void onVirtualFileCreated(VirtualFile vf) {
                if (this.projectKind$1.isDWFile(vf.url())) {
                    this.$outer.validateFile(vf, "onCreated");
                } else {
                    this.$outer.org$mule$weave$lsp$services$DataWeaveToolingService$$findCorrespondingDwFile(vf.url()).foreach((Function1 & Serializable & scala.Serializable)dwVirtualFile -> {
                        $anon$4.$anonfun$onVirtualFileCreated$1(this, dwVirtualFile);
                        return BoxedUnit.UNIT;
                    });
                }
            }

            public static final /* synthetic */ void $anonfun$onVirtualFileCreated$1($anon$4 $this, VirtualFile dwVirtualFile) {
                $this.$outer.validateFile(dwVirtualFile, "onScenarioChanged");
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.projectKind$1 = projectKind$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$onVirtualFileCreated$1$adapted(org.mule.weave.lsp.services.DataWeaveToolingService$$anon$4 org.mule.weave.v2.editor.VirtualFile )}, serializedLambda);
            }
        });
        eventBus.register(ProjectVirtualFileChangedEvent$.MODULE$.VIRTUAL_FILE_CHANGED(), new OnProjectVirtualFileChangedEvent(this, projectKind){
            private final /* synthetic */ DataWeaveToolingService $outer;
            private final ProjectKind projectKind$1;

            public void onVirtualFileChanged(VirtualFile vf) {
                if (this.projectKind$1.isDWFile(vf.url())) {
                    this.$outer.validateFile(vf, "onChanged");
                } else {
                    this.$outer.org$mule$weave$lsp$services$DataWeaveToolingService$$findCorrespondingDwFile(vf.url()).foreach((Function1 & Serializable & scala.Serializable)dwVirtualFile -> {
                        $anon$5.$anonfun$onVirtualFileChanged$1(this, dwVirtualFile);
                        return BoxedUnit.UNIT;
                    });
                }
            }

            public static final /* synthetic */ void $anonfun$onVirtualFileChanged$1($anon$5 $this, VirtualFile dwVirtualFile) {
                $this.$outer.validateFile(dwVirtualFile, "onScenarioChanged");
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.projectKind$1 = projectKind$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$onVirtualFileChanged$1$adapted(org.mule.weave.lsp.services.DataWeaveToolingService$$anon$5 org.mule.weave.v2.editor.VirtualFile )}, serializedLambda);
            }
        });
        eventBus.register(ProjectVirtualFileDeletedEvent$.MODULE$.VIRTUAL_FILE_DELETED(), new OnProjectVirtualFileDeletedEvent(this, projectKind){
            private final /* synthetic */ DataWeaveToolingService $outer;
            private final ProjectKind projectKind$1;

            public void onVirtualFileDeleted(VirtualFile vf) {
                if (this.projectKind$1.isDWFile(vf.url())) {
                    this.$outer.org$mule$weave$lsp$services$DataWeaveToolingService$$validateDependencies(vf, "onDeleted");
                } else {
                    this.$outer.org$mule$weave$lsp$services$DataWeaveToolingService$$findCorrespondingDwFile(vf.url()).foreach((Function1 & Serializable & scala.Serializable)dwVirtualFile -> {
                        $anon$6.$anonfun$onVirtualFileDeleted$1(this, dwVirtualFile);
                        return BoxedUnit.UNIT;
                    });
                }
            }

            public static final /* synthetic */ void $anonfun$onVirtualFileDeleted$1($anon$6 $this, VirtualFile dwVirtualFile) {
                $this.$outer.validateFile(dwVirtualFile, "onScenarioChanged");
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.projectKind$1 = projectKind$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$onVirtualFileDeleted$1$adapted(org.mule.weave.lsp.services.DataWeaveToolingService$$anon$6 org.mule.weave.v2.editor.VirtualFile )}, serializedLambda);
            }
        });
    }

    public Option<VirtualFile> org$mule$weave$lsp$services$DataWeaveToolingService$$findCorrespondingDwFile(String str) {
        SampleDataManager sampleDataManager = this.projectKind().sampleDataManager();
        return this.documentService().openEditors().find((Function1 & Serializable & scala.Serializable)oe -> BoxesRunTime.boxToBoolean((boolean)URLUtils$.MODULE$.isChildOfAny(str, (File[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])sampleDataManager.listScenarios(oe.file().getNameIdentifier()))).map((Function1 & Serializable & scala.Serializable)scenario -> scenario.file(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(File.class)))))).map((Function1 & Serializable & scala.Serializable)weaveDocToolingService -> weaveDocToolingService.file());
    }

    public void org$mule$weave$lsp$services$DataWeaveToolingService$$validateAllEditors(String reason) {
        Seq services = (Seq)this.documentService().openEditors().map((Function1 & Serializable & scala.Serializable)openEditor -> openEditor.file().url(), Seq$.MODULE$.canBuildFrom());
        this.documentService().invalidateAll();
        services.foreach((Function1 & Serializable & scala.Serializable)url -> {
            this.triggerValidation(url, reason, this.triggerValidation$default$3());
            return BoxedUnit.UNIT;
        });
    }

    public void org$mule$weave$lsp$services$DataWeaveToolingService$$validateDependencies(VirtualFile vf, String reason) {
        NameIdentifier fileLogicalName = vf.getNameIdentifier();
        Seq dependants = this.documentService().dependantsOf(fileLogicalName);
        this.logger().log(Level.INFO, new StringBuilder(37).append("[DWProject] Validate dependants of ").append(fileLogicalName).append(": ").append(dependants.mkString("[", ",", "]")).toString());
        dependants.foreach((Function1 & Serializable & scala.Serializable)ni -> {
            DataWeaveToolingService.$anonfun$validateDependencies$1(this, vf, reason, ni);
            return BoxedUnit.UNIT;
        });
    }

    public Option<WeaveType> loadType(String typeString) {
        return this.documentService().loadType(typeString);
    }

    private WeaveToolingService documentService() {
        return this._documentService();
    }

    public Option<MappingInput> inputOf(String uri, String inputName) {
        WeaveDocumentToolingService documentToolingService = this.openDocument(uri, this.openDocument$default$2());
        return documentToolingService.inputOf(inputName);
    }

    public Option<ContextMetadata> contextMetadataFor(String uri, boolean withExpectedOutput) {
        return this.projectKind().metadataProvider().flatMap((Function1 & Serializable & scala.Serializable)provider -> {
            VirtualFile virtualFile = this.vfs().file(uri);
            return virtualFile != null ? new Some((Object)provider.metadataFor(virtualFile, withExpectedOutput)) : None$.MODULE$;
        });
    }

    public boolean contextMetadataFor$default$2() {
        return true;
    }

    public WeaveDocumentToolingService openDocument(String uri, boolean withExpectedOutput) {
        Option<ContextMetadata> maybeContext = this.contextMetadataFor(uri, withExpectedOutput);
        return maybeContext.isDefined() ? this.openDocument(uri, (ContextMetadata)maybeContext.get()) : this.openDocumentWithoutContext(uri);
    }

    public WeaveDocumentToolingService openDocument(String uri, Option<ContextMetadata> maybeContext, boolean withExpectedOutput) {
        return maybeContext.isDefined() ? this.openDocument(uri, (ContextMetadata)maybeContext.get()) : this.openDocument(uri, withExpectedOutput);
    }

    public WeaveDocumentToolingService openDocumentWithoutContext(String uri) {
        return this._documentService().open(uri, ImplicitInput$.MODULE$.apply(), (Option)None$.MODULE$);
    }

    private WeaveDocumentToolingService openDocument(String uri, ContextMetadata contextMetadata) {
        return this._documentService().open(uri, WeaveTypeUtils$.MODULE$.toImplicitInput(contextMetadata.input().metadata()), contextMetadata.output());
    }

    public boolean openDocument$default$2() {
        return true;
    }

    public void closeDocument(String uri) {
        this.documentService().close(uri);
    }

    public WeaveToolingService withLanguageLevel(String dwLanguageLevel) {
        return this._documentService().updateLanguageLevel(SVersion$.MODULE$.fromString(dwLanguageLevel));
    }

    public void validateFile(VirtualFile vf, String reason) {
        this.triggerValidation(vf.url(), reason, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.org$mule$weave$lsp$services$DataWeaveToolingService$$validateDependencies(vf, reason));
    }

    public void triggerValidation(String documentUri, String reason, Function0<BoxedUnit> onValidationFinish) {
        this.logger().log(Level.INFO, new StringBuilder(30).append("TriggerValidation of: ").append(documentUri).append(" reason ").append(reason).toString());
        CompletableFuture.runAsync(() -> {
            this.logger().log(Level.INFO, new StringBuilder(40).append("[").append(Thread.currentThread().getName()).append("][").append(this.getClass().getName()).append("] Init TriggerValidation of: ").append(documentUri).append(" reason ").append(reason).toString());
            this.withLanguageLevel(this.projectKind().dependencyManager().languageLevel());
            ValidationMessages messages = this.validate(documentUri, this.validate$default$2());
            List<Diagnostic> diagnostics = this.toDiagnostics(messages);
            this.logger().log(Level.INFO, new StringBuilder(58).append("[").append(Thread.currentThread().getName()).append("][").append(this.getClass().getName()).append("] TriggerValidation finished: ").append(documentUri).append(" reason ").append(reason).append(". Diagnostics: [").append(diagnostics).append("]").toString());
            this.languageClient().publishDiagnostics(new PublishDiagnosticsParams(documentUri, diagnostics));
            onValidationFinish.apply$mcV$sp();
        }, this.executor);
    }

    public Function0<BoxedUnit> triggerValidation$default$3() {
        return (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {};
    }

    /*
     * WARNING - void declaration
     */
    public List<Diagnostic> toDiagnostics(ValidationMessages messages) {
        void var2_2;
        ArrayList diagnostics = new ArrayList();
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])messages.errorMessage())).foreach((Function1 & Serializable & scala.Serializable)message -> BoxesRunTime.boxToBoolean((boolean)diagnostics.add(LSPConverters$.MODULE$.toDiagnostic(message, DiagnosticSeverity.Error))));
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])messages.warningMessage())).foreach((Function1 & Serializable & scala.Serializable)message -> BoxesRunTime.boxToBoolean((boolean)diagnostics.add(LSPConverters$.MODULE$.toDiagnostic(message, DiagnosticSeverity.Warning))));
        return var2_2;
    }

    public QuickFix[] quickFixesFor(String documentUri, int startOffset, int endOffset, String kind, String severity, Option<ContextMetadata> maybeContext) {
        ValidationMessages messages = this.validate(documentUri, maybeContext);
        String string = severity;
        String string2 = DiagnosticSeverity.Error.name();
        Option messageFound = !(string != null ? !string.equals(string2) : string2 != null) ? new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])messages.errorMessage())).find((Function1 & Serializable & scala.Serializable)m -> BoxesRunTime.boxToBoolean((boolean)this.matchesMessage(m, kind, startOffset, endOffset))) : new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])messages.warningMessage())).find((Function1 & Serializable & scala.Serializable)m -> BoxesRunTime.boxToBoolean((boolean)this.matchesMessage(m, kind, startOffset, endOffset)));
        return (QuickFix[])messageFound.map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.quickFix()).getOrElse((Function0 & Serializable & scala.Serializable)() -> (QuickFix[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(QuickFix.class)));
    }

    public Option<ContextMetadata> quickFixesFor$default$6() {
        return None$.MODULE$;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean matchesMessage(ValidationMessage m, String kind, int startOffset, int endOffset) {
        if (m.location().startPosition().index() != startOffset) return false;
        if (m.location().endPosition().index() != endOffset) return false;
        String string = LSPConverters$.MODULE$.toDiagnosticKind(m);
        String string2 = kind;
        if (string != null) {
            if (!string.equals(string2)) return false;
            return true;
        }
        if (string2 == null) return true;
        return false;
    }

    public ValidationMessages validate(String documentUri, Option<ContextMetadata> maybeContext) {
        WeaveDocumentToolingService documentToolingService;
        WeaveDocumentToolingService weaveDocumentToolingService;
        if (maybeContext.isDefined()) {
            ContextMetadata context = (ContextMetadata)maybeContext.get();
            weaveDocumentToolingService = this.openDocument(documentUri, context);
        } else {
            weaveDocumentToolingService = documentToolingService = this.openDocument(documentUri, false);
        }
        ValidationMessages messages = this.indexed() && Settings$.MODULE$.isTypeLevel(this.project().settings()) ? documentToolingService.typeCheck() : (this.indexed() && Settings$.MODULE$.isScopeLevel(this.project().settings()) ? documentToolingService.scopeCheck() : documentToolingService.parseCheck());
        return messages;
    }

    public Option<ContextMetadata> validate$default$2() {
        return None$.MODULE$;
    }

    public LanguageClient languageClient() {
        return this.languageClient;
    }

    public Logger getLogger() {
        return this.logger();
    }

    public static final /* synthetic */ void $anonfun$validateDependencies$1(DataWeaveToolingService $this, VirtualFile vf$1, String reason$2, NameIdentifier ni) {
        Option option = vf$1.fs().asResourceResolver().resolve(ni);
        if (option instanceof Some) {
            Some some = (Some)option;
            WeaveResource resource = (WeaveResource)some.value();
            $this.triggerValidation(resource.url(), new StringBuilder(20).append("dependantChanged ->").append(reason$2).append(" ").append(vf$1.url()).toString(), $this.triggerValidation$default$3());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (None$.MODULE$.equals(option)) {
            $this.logger().log(Level.WARNING, new StringBuilder(27).append("No resource found for file ").append(vf$1.url()).toString());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)option);
        }
    }

    public DataWeaveToolingService(Project project, LanguageClient languageClient, VirtualFileSystem vfs, Function0<WeaveToolingService> documentServiceFactory, Executor executor) {
        this.project = project;
        this.languageClient = languageClient;
        this.vfs = vfs;
        this.documentServiceFactory = documentServiceFactory;
        this.executor = executor;
        ToolingService.$init$(this);
        this.logger = Logger.getLogger(this.getClass().getName());
        this.indexed = false;
    }
}

