/*
 * Decompiled with CFR 0.152.
 */
package org.mule.weave.lsp.services;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.lsp4j.DidChangeConfigurationParams;
import org.eclipse.lsp4j.DidChangeWatchedFilesParams;
import org.eclipse.lsp4j.DidChangeWorkspaceFoldersParams;
import org.eclipse.lsp4j.ExecuteCommandParams;
import org.eclipse.lsp4j.Location;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.SymbolInformation;
import org.eclipse.lsp4j.SymbolKind;
import org.eclipse.lsp4j.WorkspaceSymbolParams;
import org.eclipse.lsp4j.services.WorkspaceService;
import org.mule.weave.lsp.commands.CommandProvider;
import org.mule.weave.lsp.commands.Commands$;
import org.mule.weave.lsp.commands.WeaveCommand;
import org.mule.weave.lsp.extension.client.SetContextParams;
import org.mule.weave.lsp.extension.client.SetContextValue;
import org.mule.weave.lsp.extension.client.WeaveLanguageClient;
import org.mule.weave.lsp.indexer.LSPWeaveIndexService;
import org.mule.weave.lsp.jobs.JobManagerService;
import org.mule.weave.lsp.jobs.Status;
import org.mule.weave.lsp.jobs.Task;
import org.mule.weave.lsp.project.Project;
import org.mule.weave.lsp.project.ProjectKind;
import org.mule.weave.lsp.services.ClientLogger;
import org.mule.weave.lsp.services.ToolingService;
import org.mule.weave.lsp.services.events.DocumentChangedEvent$;
import org.mule.weave.lsp.services.events.DocumentFocusChangedEvent$;
import org.mule.weave.lsp.services.events.DocumentOpenedEvent$;
import org.mule.weave.lsp.services.events.FileChangedEvent;
import org.mule.weave.lsp.services.events.OnDocumentChanged;
import org.mule.weave.lsp.services.events.OnDocumentFocused;
import org.mule.weave.lsp.services.events.OnDocumentOpened;
import org.mule.weave.lsp.utils.EventBus;
import org.mule.weave.lsp.utils.LSPConverters$;
import org.mule.weave.v2.editor.VirtualFile;
import org.mule.weave.v2.editor.VirtualFileSystem;
import org.mule.weave.v2.editor.indexing.IdentifierType$;
import org.mule.weave.v2.editor.indexing.LocatedResult;
import org.mule.weave.v2.editor.indexing.WeaveIdentifier;
import org.mule.weave.v2.parser.ast.variables.NameIdentifier;
import org.mule.weave.v2.parser.location.Position;
import org.mule.weave.v2.sdk.WeaveResource;
import org.mule.weave.v2.sdk.WeaveResourceResolver;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Iterable;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;

@ScalaSignature(bytes="\u0006\u0001\u0005\rg\u0001\u0002\r\u001a\u0001\u0011B\u0001B\u000f\u0001\u0003\u0002\u0003\u0006Ia\u000f\u0005\t\u0001\u0002\u0011\t\u0011)A\u0005\u0003\"A\u0011\n\u0001B\u0001B\u0003%!\n\u0003\u0005N\u0001\t\u0005\t\u0015!\u0003O\u0011!1\u0006A!A!\u0002\u00139\u0006\u0002C/\u0001\u0005\u0003\u0005\u000b\u0011\u00020\t\u0011\u0011\u0004!\u0011!Q\u0001\n\u0015DQa\u001b\u0001\u0005\u00021Dq!\u001e\u0001C\u0002\u0013%a\u000f\u0003\u0004\u0000\u0001\u0001\u0006Ia\u001e\u0005\f\u0003\u0003\u0001\u0001\u0019!a\u0001\n\u0013\t\u0019\u0001C\u0006\u0002\u0012\u0001\u0001\r\u00111A\u0005\n\u0005M\u0001bCA\u0013\u0001\u0001\u0007\t\u0011)Q\u0005\u0003\u000bA1\"a\n\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002*!Y\u0011\u0011\u0007\u0001A\u0002\u0003\u0007I\u0011BA\u001a\u0011-\t9\u0004\u0001a\u0001\u0002\u0003\u0006K!a\u000b\t\u000f\u0005e\u0002\u0001\"\u0011\u0002<!9\u0011\u0011\t\u0001\u0005\n\u0005\r\u0003bBA(\u0001\u0011\u0005\u0013\u0011\u000b\u0005\b\u0003\u0017\u0003A\u0011IAG\u0011\u001d\t9\n\u0001C!\u00033Cq!a+\u0001\t\u0003\ni\u000bC\u0004\u00028\u0002!\t%!/\u00033\u0011\u000bG/Y,fCZ,wk\u001c:lgB\f7-Z*feZL7-\u001a\u0006\u00035m\t\u0001b]3sm&\u001cWm\u001d\u0006\u00039u\t1\u0001\\:q\u0015\tqr$A\u0003xK\u00064XM\u0003\u0002!C\u0005!Q.\u001e7f\u0015\u0005\u0011\u0013aA8sO\u000e\u00011\u0003\u0002\u0001&[Y\u0002\"AJ\u0016\u000e\u0003\u001dR!\u0001K\u0015\u0002\t1\fgn\u001a\u0006\u0002U\u0005!!.\u0019<b\u0013\tasE\u0001\u0004PE*,7\r\u001e\t\u0003]Qj\u0011a\f\u0006\u00035AR!!\r\u001a\u0002\u000b1\u001c\b\u000f\u000e6\u000b\u0005M\n\u0013aB3dY&\u00048/Z\u0005\u0003k=\u0012\u0001cV8sWN\u0004\u0018mY3TKJ4\u0018nY3\u0011\u0005]BT\"A\r\n\u0005eJ\"A\u0004+p_2LgnZ*feZL7-Z\u0001\baJ|'.Z2u!\tad(D\u0001>\u0015\tQ4$\u0003\u0002@{\t9\u0001K]8kK\u000e$\u0018a\u0001<ggB\u0011!iR\u0007\u0002\u0007*\u0011A)R\u0001\u0007K\u0012LGo\u001c:\u000b\u0005\u0019k\u0012A\u0001<3\u0013\tA5IA\tWSJ$X/\u00197GS2,7+_:uK6\fAb\u00197jK:$Hj\\4hKJ\u0004\"aN&\n\u00051K\"\u0001D\"mS\u0016tG\u000fT8hO\u0016\u0014\u0018A\u00047b]\u001e,\u0018mZ3DY&,g\u000e\u001e\t\u0003\u001fRk\u0011\u0001\u0015\u0006\u0003#J\u000baa\u00197jK:$(BA*\u001c\u0003%)\u0007\u0010^3og&|g.\u0003\u0002V!\n\u0019r+Z1wK2\u000bgnZ;bO\u0016\u001cE.[3oi\u0006\t\"n\u001c2NC:\fw-\u001a:TKJ4\u0018nY3\u0011\u0005a[V\"A-\u000b\u0005i[\u0012\u0001\u00026pENL!\u0001X-\u0003#){'-T1oC\u001e,'oU3sm&\u001cW-\u0001\u0007j]\u0012,\u0007pU3sm&\u001cW\r\u0005\u0002`E6\t\u0001M\u0003\u0002b7\u00059\u0011N\u001c3fq\u0016\u0014\u0018BA2a\u0005Qa5\u000bU,fCZ,\u0017J\u001c3fqN+'O^5dK\u0006y1m\\7nC:$\u0007K]8wS\u0012,'\u000f\u0005\u0002gS6\tqM\u0003\u0002i7\u0005A1m\\7nC:$7/\u0003\u0002kO\ny1i\\7nC:$\u0007K]8wS\u0012,'/\u0001\u0004=S:LGO\u0010\u000b\t[:|\u0007/\u001d:tiB\u0011q\u0007\u0001\u0005\u0006u!\u0001\ra\u000f\u0005\u0006\u0001\"\u0001\r!\u0011\u0005\u0006\u0013\"\u0001\rA\u0013\u0005\u0006\u001b\"\u0001\rA\u0014\u0005\u0006-\"\u0001\ra\u0016\u0005\u0006;\"\u0001\rA\u0018\u0005\u0006I\"\u0001\r!Z\u0001\u0007Y><w-\u001a:\u0016\u0003]\u0004\"\u0001_?\u000e\u0003eT!A_>\u0002\u000f1|wmZ5oO*\u0011A0K\u0001\u0005kRLG.\u0003\u0002\u007fs\n1Aj\\4hKJ\fq\u0001\\8hO\u0016\u0014\b%\u0001\u0005fm\u0016tGOQ;t+\t\t)\u0001\u0005\u0003\u0002\b\u00055QBAA\u0005\u0015\r\tYaG\u0001\u0006kRLGn]\u0005\u0005\u0003\u001f\tIA\u0001\u0005Fm\u0016tGOQ;t\u00031)g/\u001a8u\u0005V\u001cx\fJ3r)\u0011\t)\"!\t\u0011\t\u0005]\u0011QD\u0007\u0003\u00033Q!!a\u0007\u0002\u000bM\u001c\u0017\r\\1\n\t\u0005}\u0011\u0011\u0004\u0002\u0005+:LG\u000fC\u0005\u0002$1\t\t\u00111\u0001\u0002\u0006\u0005\u0019\u0001\u0010J\u0019\u0002\u0013\u00154XM\u001c;CkN\u0004\u0013a\u00039s_*,7\r^&j]\u0012,\"!a\u000b\u0011\u0007q\ni#C\u0002\u00020u\u00121\u0002\u0015:pU\u0016\u001cGoS5oI\u0006y\u0001O]8kK\u000e$8*\u001b8e?\u0012*\u0017\u000f\u0006\u0003\u0002\u0016\u0005U\u0002\"CA\u0012\u001f\u0005\u0005\t\u0019AA\u0016\u00031\u0001(o\u001c6fGR\\\u0015N\u001c3!\u0003\u0011Ig.\u001b;\u0015\r\u0005U\u0011QHA \u0011\u001d\t9#\u0005a\u0001\u0003WAq!!\u0001\u0012\u0001\u0004\t)!\u0001\u000bo_RLg-_\"p]R,\u0007\u0010^\"iC:<W\r\u001a\u000b\u0005\u0003+\t)\u0005C\u0004\u0002HI\u0001\r!!\u0013\u0002\u0005Y4\u0007c\u0001\"\u0002L%\u0019\u0011QJ\"\u0003\u0017YK'\u000f^;bY\u001aKG.Z\u0001\u0007gfl'm\u001c7\u0015\t\u0005M\u0013\u0011\u0011\t\u0007\u0003+\nY&a\u0018\u000e\u0005\u0005]#bAA-w\u0006Q1m\u001c8dkJ\u0014XM\u001c;\n\t\u0005u\u0013q\u000b\u0002\u0012\u0007>l\u0007\u000f\\3uC\ndWMR;ukJ,\u0007\u0007BA1\u0003[\u0002b!a\u0019\u0002f\u0005%T\"A>\n\u0007\u0005\u001d4P\u0001\u0003MSN$\b\u0003BA6\u0003[b\u0001\u0001B\u0006\u0002pM\t\t\u0011!A\u0003\u0002\u0005E$aA0%cE!\u00111OA=!\u0011\t9\"!\u001e\n\t\u0005]\u0014\u0011\u0004\u0002\b\u001d>$\b.\u001b8h!\u0011\tY(! \u000e\u0003AJ1!a 1\u0005E\u0019\u00160\u001c2pY&sgm\u001c:nCRLwN\u001c\u0005\b\u0003\u0007\u001b\u0002\u0019AAC\u0003\u0019\u0001\u0018M]1ngB!\u00111PAD\u0013\r\tI\t\r\u0002\u0016/>\u00148n\u001d9bG\u0016\u001c\u00160\u001c2pYB\u000b'/Y7t\u0003Y!\u0017\u000eZ\"iC:<WmQ8oM&<WO]1uS>tG\u0003BA\u000b\u0003\u001fCq!a!\u0015\u0001\u0004\t\t\n\u0005\u0003\u0002|\u0005M\u0015bAAKa\taB)\u001b3DQ\u0006tw-Z\"p]\u001aLw-\u001e:bi&|g\u000eU1sC6\u001c\u0018AD3yK\u000e,H/Z\"p[6\fg\u000e\u001a\u000b\u0005\u00037\u000b\u0019\u000b\u0005\u0004\u0002V\u0005m\u0013Q\u0014\t\u0005\u0003/\ty*\u0003\u0003\u0002\"\u0006e!AB!osJ+g\rC\u0004\u0002\u0004V\u0001\r!!*\u0011\t\u0005m\u0014qU\u0005\u0004\u0003S\u0003$\u0001F#yK\u000e,H/Z\"p[6\fg\u000e\u001a)be\u0006l7/A\reS\u0012\u001c\u0005.\u00198hK^{'o[:qC\u000e,gi\u001c7eKJ\u001cH\u0003BA\u000b\u0003_Cq!a!\u0017\u0001\u0004\t\t\f\u0005\u0003\u0002|\u0005M\u0016bAA[a\tyB)\u001b3DQ\u0006tw-Z,pe.\u001c\b/Y2f\r>dG-\u001a:t!\u0006\u0014\u0018-\\:\u0002+\u0011LGm\u00115b]\u001e,w+\u0019;dQ\u0016$g)\u001b7fgR!\u0011QCA^\u0011\u001d\t\u0019i\u0006a\u0001\u0003{\u0003B!a\u001f\u0002@&\u0019\u0011\u0011\u0019\u0019\u00037\u0011KGm\u00115b]\u001e,w+\u0019;dQ\u0016$g)\u001b7fgB\u000b'/Y7t\u0001")
public class DataWeaveWorkspaceService
implements WorkspaceService,
ToolingService {
    private final Project project;
    private final VirtualFileSystem vfs;
    private final ClientLogger clientLogger;
    private final WeaveLanguageClient languageClient;
    private final JobManagerService jobManagerService;
    private final LSPWeaveIndexService indexService;
    private final CommandProvider commandProvider;
    private final Logger logger;
    private EventBus eventBus;
    private ProjectKind projectKind;

    private Logger logger() {
        return this.logger;
    }

    private EventBus eventBus() {
        return this.eventBus;
    }

    private void eventBus_$eq(EventBus x$1) {
        this.eventBus = x$1;
    }

    private ProjectKind projectKind() {
        return this.projectKind;
    }

    private void projectKind_$eq(ProjectKind x$1) {
        this.projectKind = x$1;
    }

    @Override
    public void init(ProjectKind projectKind, EventBus eventBus) {
        this.eventBus_$eq(eventBus);
        this.projectKind_$eq(projectKind);
        eventBus.register(DocumentChangedEvent$.MODULE$.DOCUMENT_CHANGED(), new OnDocumentChanged(this){
            private final /* synthetic */ DataWeaveWorkspaceService $outer;

            public void onDocumentChanged(VirtualFile vf) {
                this.$outer.org$mule$weave$lsp$services$DataWeaveWorkspaceService$$notifyContextChanged(vf);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        eventBus.register(DocumentOpenedEvent$.MODULE$.DOCUMENT_OPENED(), new OnDocumentOpened(this){
            private final /* synthetic */ DataWeaveWorkspaceService $outer;

            public void onDocumentOpened(VirtualFile vf) {
                this.$outer.org$mule$weave$lsp$services$DataWeaveWorkspaceService$$notifyContextChanged(vf);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        eventBus.register(DocumentFocusChangedEvent$.MODULE$.DOCUMENT_FOCUS_CHANGED(), new OnDocumentFocused(this){
            private final /* synthetic */ DataWeaveWorkspaceService $outer;

            public void onDocumentFocused(VirtualFile vf) {
                this.$outer.org$mule$weave$lsp$services$DataWeaveWorkspaceService$$notifyContextChanged(vf);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public void org$mule$weave$lsp$services$DataWeaveWorkspaceService$$notifyContextChanged(VirtualFile vf) {
        SetContextParams params = new SetContextParams((List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)this.commandProvider.commands().map((Function1 & Serializable & scala.Serializable)command -> new SetContextValue(new StringBuilder(0).append(command.commandId()).append(Commands$.MODULE$.COMMAND_ENABLED_SUFFIX()).toString(), command.enabled(vf), vf.url()), Seq$.MODULE$.canBuildFrom())).asJava());
        this.languageClient.setContext(params);
    }

    public CompletableFuture<List<? extends SymbolInformation>> symbol(WorkspaceSymbolParams params) {
        return CompletableFuture.supplyAsync(() -> {
            WeaveResourceResolver resourceResolver = $this.vfs.asResourceResolver();
            Iterable<LocatedResult<WeaveIdentifier>> iterable = $this.indexService.searchSymbol(params.getQuery());
            ArrayList result = new ArrayList();
            iterable.foreach((Function1 & Serializable & scala.Serializable)lr -> {
                Object object;
                Option moduleResource;
                SymbolInformation information = new SymbolInformation();
                information.setName(((WeaveIdentifier)lr.value()).value());
                int n = ((WeaveIdentifier)lr.value()).idType();
                SymbolKind symbolKind = IdentifierType$.MODULE$.FUNCTION() == n ? SymbolKind.Function : (IdentifierType$.MODULE$.VARIABLE() == n ? SymbolKind.Variable : (IdentifierType$.MODULE$.NAMESPACE() == n ? SymbolKind.Namespace : (IdentifierType$.MODULE$.ANNOTATION() == n ? SymbolKind.Interface : SymbolKind.Field)));
                SymbolKind kind = symbolKind;
                information.setKind(kind);
                NameIdentifier name = lr.moduleName();
                Option option = moduleResource = resourceResolver.resolve(name);
                if (option instanceof Some) {
                    Some some = (Some)option;
                    WeaveResource weaveResource = (WeaveResource)some.value();
                    Range range = new Range();
                    Position startPosition = weaveResource.positionOf(((WeaveIdentifier)lr.value()).startLocation());
                    Position endPosition = weaveResource.positionOf(((WeaveIdentifier)lr.value()).endLocation());
                    range.setStart(LSPConverters$.MODULE$.toPosition(startPosition));
                    range.setEnd(LSPConverters$.MODULE$.toPosition(endPosition));
                    Location location = new Location(weaveResource.url(), range);
                    information.setLocation(location);
                    object = BoxesRunTime.boxToBoolean((boolean)result.add(information));
                } else {
                    object = BoxedUnit.UNIT;
                }
                return object;
            });
            return result;
        });
    }

    public void didChangeConfiguration(DidChangeConfigurationParams params) {
        this.logger().log(Level.INFO, new StringBuilder(24).append("didChangeConfiguration: ").append(params.getSettings()).toString());
        this.project.settings().update(params.getSettings());
    }

    public CompletableFuture<Object> executeCommand(ExecuteCommandParams params) {
        this.logger().log(Level.INFO, new StringBuilder(16).append("executeCommand: ").append(params).toString());
        return CompletableFuture.supplyAsync(() -> $this.commandProvider.commandBy(params.getCommand()).map((Function1 & Serializable & scala.Serializable)c -> {
            ObjectRef result = ObjectRef.create(null);
            $this.jobManagerService.execute(new Task(null, result, (WeaveCommand)c, params){
                private final ObjectRef result$2;
                private final WeaveCommand c$1;
                private final ExecuteCommandParams params$2;

                public void run(Status cancelable) {
                    this.result$2.elem = this.c$1.execute(this.params$2);
                }
                {
                    this.result$2 = result$2;
                    this.c$1 = c$1;
                    this.params$2 = params$2;
                }
            }, new StringBuilder(17).append("Running command: ").append(c.name()).toString(), String.valueOf(c.description(params)));
            return result.elem;
        }).orNull(Predef$.MODULE$.$conforms()));
    }

    public void didChangeWorkspaceFolders(DidChangeWorkspaceFoldersParams params) {
        this.logger().log(Level.INFO, new StringBuilder(45).append("[DataWeaveWorkspaceService] Changed Folders: ").append(params.getEvent()).toString());
    }

    public void didChangeWatchedFiles(DidChangeWatchedFilesParams params) {
        params.getChanges().forEach(fe -> {
            if (this.projectKind().isProjectFile(fe.getUri())) {
                $this.clientLogger.logDebug(new StringBuilder(54).append("[DataWeaveWorkspaceService] Changed Watched File : ").append(fe.getUri()).append(" - ").append(fe.getType()).toString());
                this.eventBus().fire(new FileChangedEvent(fe.getUri(), fe.getType()));
            } else {
                $this.clientLogger.logDebug(new StringBuilder(54).append("[DataWeaveWorkspaceService] Ignored Watched File : ").append(fe.getUri()).append(" - ").append(fe.getType()).toString());
            }
        });
    }

    public DataWeaveWorkspaceService(Project project, VirtualFileSystem vfs, ClientLogger clientLogger, WeaveLanguageClient languageClient, JobManagerService jobManagerService, LSPWeaveIndexService indexService, CommandProvider commandProvider) {
        this.project = project;
        this.vfs = vfs;
        this.clientLogger = clientLogger;
        this.languageClient = languageClient;
        this.jobManagerService = jobManagerService;
        this.indexService = indexService;
        this.commandProvider = commandProvider;
        ToolingService.$init$(this);
        this.logger = Logger.getLogger(this.getClass().getName());
    }
}

