/*
 * Decompiled with CFR 0.152.
 */
package org.mule.weave.lsp.services;

import java.io.File;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import org.eclipse.lsp4j.FileChangeType;
import org.mule.weave.lsp.agent.WeaveAgentService;
import org.mule.weave.lsp.extension.client.PreviewResult;
import org.mule.weave.lsp.extension.client.PreviewResult$;
import org.mule.weave.lsp.extension.client.WeaveLanguageClient;
import org.mule.weave.lsp.jobs.JobManagerService;
import org.mule.weave.lsp.project.Project;
import org.mule.weave.lsp.project.ProjectKind;
import org.mule.weave.lsp.project.events.OnProjectStarted;
import org.mule.weave.lsp.project.events.ProjectStartedEvent$;
import org.mule.weave.lsp.services.DataWeaveToolingService;
import org.mule.weave.lsp.services.Debouncer;
import org.mule.weave.lsp.services.PreviewService$;
import org.mule.weave.lsp.services.ToolingService;
import org.mule.weave.lsp.services.events.ActiveScenarioChangedEvent$;
import org.mule.weave.lsp.services.events.DocumentChangedEvent$;
import org.mule.weave.lsp.services.events.DocumentFocusChangedEvent$;
import org.mule.weave.lsp.services.events.FileChangedEvent$;
import org.mule.weave.lsp.services.events.OnActiveScenarioChanged;
import org.mule.weave.lsp.services.events.OnDocumentChanged;
import org.mule.weave.lsp.services.events.OnDocumentFocused;
import org.mule.weave.lsp.services.events.OnFileChanged;
import org.mule.weave.lsp.utils.EventBus;
import org.mule.weave.lsp.utils.URLUtils$;
import org.mule.weave.lsp.utils.WeaveASTQueryUtils$;
import org.mule.weave.v2.editor.VirtualFile;
import org.mule.weave.v2.editor.WeaveDocumentToolingService;
import org.mule.weave.v2.parser.ast.AstNode;
import org.mule.weave.v2.parser.ast.variables.NameIdentifier;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;

@ScalaSignature(bytes="\u0006\u0001\u0005]g\u0001\u0002\u0012$\u00019B\u0001\"\u000f\u0001\u0003\u0002\u0003\u0006IA\u000f\u0005\t\u0001\u0002\u0011\t\u0011)A\u0005\u0003\"A\u0011\n\u0001B\u0001B\u0003%!\n\u0003\u0005P\u0001\t\u0005\t\u0015!\u0003Q\u0011!\u0019\u0006A!A!\u0002\u0013!\u0006\u0002\u0003.\u0001\u0005\u0003\u0005\u000b\u0011B.\t\u000b\u0019\u0004A\u0011A4\t\u000f=\u0004!\u0019!C\u0005a\"11\u0010\u0001Q\u0001\nED\u0011\u0002 \u0001A\u0002\u0003\u0007I\u0011B?\t\u0017\u0005%\u0001\u00011AA\u0002\u0013%\u00111\u0002\u0005\u000b\u0003/\u0001\u0001\u0019!A!B\u0013q\b\"CA\r\u0001\u0001\u0007I\u0011BA\u000e\u0011%\t\u0019\u0003\u0001a\u0001\n\u0013\t)\u0003\u0003\u0005\u0002*\u0001\u0001\u000b\u0015BA\u000f\u0011%\t\u0019\u0004\u0001a\u0001\n\u0013\t)\u0004C\u0005\u0002N\u0001\u0001\r\u0011\"\u0003\u0002P!A\u00111\u000b\u0001!B\u0013\t9\u0004C\u0005\u0002V\u0001\u0001\r\u0011\"\u0003\u00026!I\u0011q\u000b\u0001A\u0002\u0013%\u0011\u0011\f\u0005\t\u0003;\u0002\u0001\u0015)\u0003\u00028!I\u0011q\f\u0001C\u0002\u0013%\u0011\u0011\r\u0005\t\u0003{\u0002\u0001\u0015!\u0003\u0002d!9\u0011q\u0010\u0001\u0005B\u0005\u0005\u0005bBAH\u0001\u0011\u0005\u0011\u0011\u0013\u0005\b\u0003;\u0003A\u0011AAP\u0011\u001d\ti\n\u0001C\u0001\u0003WCq!!(\u0001\t\u0013\ty\u000bC\u0004\u0002@\u0002!I!!1\t\u000f\u0005}\u0006\u0001\"\u0003\u0002H\"9\u00111\u001a\u0001\u0005\u0002\u00055\u0007bBAi\u0001\u0011\u0005\u00111\u001b\u0005\b\u0003+\u0004A\u0011AAj\u00059\u0001&/\u001a<jK^\u001cVM\u001d<jG\u0016T!\u0001J\u0013\u0002\u0011M,'O^5dKNT!AJ\u0014\u0002\u00071\u001c\bO\u0003\u0002)S\u0005)q/Z1wK*\u0011!fK\u0001\u0005[VdWMC\u0001-\u0003\ry'oZ\u0002\u0001'\r\u0001q&\u000e\t\u0003aMj\u0011!\r\u0006\u0002e\u0005)1oY1mC&\u0011A'\r\u0002\u0007\u0003:L(+\u001a4\u0011\u0005Y:T\"A\u0012\n\u0005a\u001a#A\u0004+p_2LgnZ*feZL7-Z\u0001\rC\u001e,g\u000e^*feZL7-\u001a\t\u0003wyj\u0011\u0001\u0010\u0006\u0003{\u0015\nQ!Y4f]RL!a\u0010\u001f\u0003#]+\u0017M^3BO\u0016tGoU3sm&\u001cW-A\nxK\u00064X\rT1oOV\fw-Z\"mS\u0016tG\u000f\u0005\u0002C\u000f6\t1I\u0003\u0002E\u000b\u000611\r\\5f]RT!AR\u0013\u0002\u0013\u0015DH/\u001a8tS>t\u0017B\u0001%D\u0005M9V-\u0019<f\u0019\u0006tw-^1hK\u000ec\u0017.\u001a8u\u0003\u001d\u0001(o\u001c6fGR\u0004\"aS'\u000e\u00031S!!S\u0013\n\u00059c%a\u0002)s_*,7\r^\u0001\u0010i>|G.\u001b8h'\u0016\u0014h/[2fgB\u0011a'U\u0005\u0003%\u000e\u0012q\u0003R1uC^+\u0017M^3U_>d\u0017N\\4TKJ4\u0018nY3\u0002\u0015)|'-T1oC\u001e,'\u000f\u0005\u0002V16\taK\u0003\u0002XK\u0005!!n\u001c2t\u0013\tIfKA\tK_\nl\u0015M\\1hKJ\u001cVM\u001d<jG\u0016\fQ\u0002\u001d:fm&,woU2iK6,\u0007C\u0001/d\u001d\ti\u0016\r\u0005\u0002_c5\tqL\u0003\u0002a[\u00051AH]8pizJ!AY\u0019\u0002\rA\u0013X\rZ3g\u0013\t!WM\u0001\u0004TiJLgn\u001a\u0006\u0003EF\na\u0001P5oSRtDc\u00025jU.dWN\u001c\t\u0003m\u0001AQ!O\u0004A\u0002iBQ\u0001Q\u0004A\u0002\u0005CQ!S\u0004A\u0002)CQaT\u0004A\u0002ACQaU\u0004A\u0002QCQAW\u0004A\u0002m\u000ba\u0001\\8hO\u0016\u0014X#A9\u0011\u0005ILX\"A:\u000b\u0005Q,\u0018a\u00027pO\u001eLgn\u001a\u0006\u0003m^\fA!\u001e;jY*\t\u00010\u0001\u0003kCZ\f\u0017B\u0001>t\u0005\u0019aunZ4fe\u00069An\\4hKJ\u0004\u0013\u0001C3wK:$()^:\u0016\u0003y\u00042a`A\u0003\u001b\t\t\tAC\u0002\u0002\u0004\u0015\nQ!\u001e;jYNLA!a\u0002\u0002\u0002\tAQI^3oi\n+8/\u0001\u0007fm\u0016tGOQ;t?\u0012*\u0017\u000f\u0006\u0003\u0002\u000e\u0005M\u0001c\u0001\u0019\u0002\u0010%\u0019\u0011\u0011C\u0019\u0003\tUs\u0017\u000e\u001e\u0005\t\u0003+Y\u0011\u0011!a\u0001}\u0006\u0019\u0001\u0010J\u0019\u0002\u0013\u00154XM\u001c;CkN\u0004\u0013aC3oC\ndWMV1mk\u0016,\"!!\b\u0011\u0007A\ny\"C\u0002\u0002\"E\u0012qAQ8pY\u0016\fg.A\bf]\u0006\u0014G.\u001a,bYV,w\fJ3r)\u0011\ti!a\n\t\u0013\u0005Ua\"!AA\u0002\u0005u\u0011\u0001D3oC\ndWMV1mk\u0016\u0004\u0003fA\b\u0002.A\u0019\u0001'a\f\n\u0007\u0005E\u0012G\u0001\u0005w_2\fG/\u001b7f\u0003M\u0001XM\u001c3j]\u001e\u0004&o\u001c6fGR\u001cF/\u0019:u+\t\t9\u0004E\u00031\u0003s\ti$C\u0002\u0002<E\u0012aa\u00149uS>t\u0007\u0003BA \u0003\u0013j!!!\u0011\u000b\t\u0005\r\u0013QI\u0001\u0007K\u0012LGo\u001c:\u000b\u0007\u0005\u001ds%\u0001\u0002we%!\u00111JA!\u0005-1\u0016N\u001d;vC24\u0015\u000e\\3\u0002/A,g\u000eZ5oOB\u0013xN[3diN#\u0018M\u001d;`I\u0015\fH\u0003BA\u0007\u0003#B\u0011\"!\u0006\u0012\u0003\u0003\u0005\r!a\u000e\u0002)A,g\u000eZ5oOB\u0013xN[3diN#\u0018M\u001d;!\u0003A\u0019WO\u001d:f]R4f\r\u0015:fm&,w/\u0001\u000bdkJ\u0014XM\u001c;WMB\u0013XM^5fo~#S-\u001d\u000b\u0005\u0003\u001b\tY\u0006C\u0005\u0002\u0016Q\t\t\u00111\u0001\u00028\u0005\t2-\u001e:sK:$hK\u001a)sKZLWm\u001e\u0011\u0002!A\u0014XM^5fo\u0012+'m\\;oG\u0016\u0014XCAA2!\u00151\u0014QMA5\u0013\r\t9g\t\u0002\n\t\u0016\u0014w.\u001e8dKJ\u0004B!a\u001b\u0002z5\u0011\u0011Q\u000e\u0006\u0005\u0003_\n\t(A\u0005wCJL\u0017M\u00197fg*!\u00111OA;\u0003\r\t7\u000f\u001e\u0006\u0005\u0003o\n)%\u0001\u0004qCJ\u001cXM]\u0005\u0005\u0003w\niG\u0001\bOC6,\u0017\nZ3oi&4\u0017.\u001a:\u0002#A\u0014XM^5fo\u0012+'m\\;oG\u0016\u0014\b%\u0001\u0003j]&$HCBA\u0007\u0003\u0007\u000bi\tC\u0004\u0002\u0006b\u0001\r!a\"\u0002\u0017A\u0014xN[3di.Kg\u000e\u001a\t\u0004\u0017\u0006%\u0015bAAF\u0019\nY\u0001K]8kK\u000e$8*\u001b8e\u0011\u0015a\b\u00041\u0001\u007f\u0003)\u0011XO\u001c)sKZLWm\u001e\u000b\u0005\u0003'\u000bI\nE\u0002C\u0003+K1!a&D\u00055\u0001&/\u001a<jK^\u0014Vm];mi\"9\u00111T\rA\u0002\u0005u\u0012A\u0001<g\u00035\u0019\u0017M\u001c*v]B\u0013XM^5foR!\u0011QDAQ\u0011\u001d\t\u0019K\u0007a\u0001\u0003K\u000ba\u0003Z8dk6,g\u000e\u001e+p_2LgnZ*feZL7-\u001a\t\u0005\u0003\u007f\t9+\u0003\u0003\u0002*\u0006\u0005#aG,fCZ,Gi\\2v[\u0016tG\u000fV8pY&twmU3sm&\u001cW\r\u0006\u0003\u0002\u001e\u00055\u0006bBAN7\u0001\u0007\u0011Q\b\u000b\u0007\u0003;\t\t,a-\t\u000f\u0005mE\u00041\u0001\u0002>!9\u0011Q\u0017\u000fA\u0002\u0005]\u0016\u0001\u00054jY\u0016\\\u0015N\u001c3SKN|GN^3s!\u0015\u0001\u0014\u0011XA_\u0013\r\tY,\r\u0002\n\rVt7\r^5p]B\u0002B\u0001MA\u001d7\u0006Aa-\u001b7f\u0017&tG\r\u0006\u0003\u0002>\u0006\r\u0007BBAc;\u0001\u00071,A\u0004gS2,WK\u001d7\u0015\t\u0005u\u0016\u0011\u001a\u0005\b\u0003Gs\u0002\u0019AAS\u0003I\u00198\r[3ek2,'+\u001e8Qe\u00164\u0018.Z<\u0015\t\u00055\u0011q\u001a\u0005\b\u00037{\u0002\u0019AA\u001f\u0003\u0019)g.\u00192mKR\u0011\u0011QB\u0001\bI&\u001c\u0018M\u00197f\u0001")
public class PreviewService
implements ToolingService {
    private final WeaveAgentService agentService;
    private final WeaveLanguageClient weaveLanguageClient;
    private final Project project;
    private final DataWeaveToolingService toolingServices;
    private final JobManagerService jobManager;
    private final String previewScheme;
    private final Logger logger;
    private EventBus eventBus;
    private volatile boolean org$mule$weave$lsp$services$PreviewService$$enableValue;
    private Option<VirtualFile> org$mule$weave$lsp$services$PreviewService$$pendingProjectStart;
    private Option<VirtualFile> org$mule$weave$lsp$services$PreviewService$$currentVfPreview;
    private final Debouncer<NameIdentifier> previewDebouncer;

    private Logger logger() {
        return this.logger;
    }

    private EventBus eventBus() {
        return this.eventBus;
    }

    private void eventBus_$eq(EventBus x$1) {
        this.eventBus = x$1;
    }

    public boolean org$mule$weave$lsp$services$PreviewService$$enableValue() {
        return this.org$mule$weave$lsp$services$PreviewService$$enableValue;
    }

    private void org$mule$weave$lsp$services$PreviewService$$enableValue_$eq(boolean x$1) {
        this.org$mule$weave$lsp$services$PreviewService$$enableValue = x$1;
    }

    public Option<VirtualFile> org$mule$weave$lsp$services$PreviewService$$pendingProjectStart() {
        return this.org$mule$weave$lsp$services$PreviewService$$pendingProjectStart;
    }

    public void org$mule$weave$lsp$services$PreviewService$$pendingProjectStart_$eq(Option<VirtualFile> x$1) {
        this.org$mule$weave$lsp$services$PreviewService$$pendingProjectStart = x$1;
    }

    public Option<VirtualFile> org$mule$weave$lsp$services$PreviewService$$currentVfPreview() {
        return this.org$mule$weave$lsp$services$PreviewService$$currentVfPreview;
    }

    private void org$mule$weave$lsp$services$PreviewService$$currentVfPreview_$eq(Option<VirtualFile> x$1) {
        this.org$mule$weave$lsp$services$PreviewService$$currentVfPreview = x$1;
    }

    private Debouncer<NameIdentifier> previewDebouncer() {
        return this.previewDebouncer;
    }

    @Override
    public void init(ProjectKind projectKind, EventBus eventBus) {
        this.eventBus_$eq(eventBus);
        eventBus.register(DocumentChangedEvent$.MODULE$.DOCUMENT_CHANGED(), new OnDocumentChanged(this){
            private final /* synthetic */ PreviewService $outer;

            public void onDocumentChanged(VirtualFile vf) {
                block0: {
                    if (!this.$outer.org$mule$weave$lsp$services$PreviewService$$enableValue() || !this.$outer.canRunPreview(vf)) break block0;
                    this.$outer.scheduleRunPreview(vf);
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        eventBus.register(DocumentFocusChangedEvent$.MODULE$.DOCUMENT_FOCUS_CHANGED(), new OnDocumentFocused(this){
            private final /* synthetic */ PreviewService $outer;

            public void onDocumentFocused(VirtualFile vf) {
                block0: {
                    if (!this.$outer.org$mule$weave$lsp$services$PreviewService$$enableValue() || !this.$outer.canRunPreview(vf)) break block0;
                    this.$outer.scheduleRunPreview(vf);
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        eventBus.register(FileChangedEvent$.MODULE$.FILE_CHANGED_EVENT(), new OnFileChanged(this, projectKind){
            private final /* synthetic */ PreviewService $outer;
            private final ProjectKind projectKind$1;

            public void onFileChanged(String uri, FileChangeType changeType) {
                block0: {
                    if (!this.$outer.org$mule$weave$lsp$services$PreviewService$$enableValue()) break block0;
                    this.$outer.org$mule$weave$lsp$services$PreviewService$$currentVfPreview().map((Function1 & Serializable & scala.Serializable)currentVFPreview -> $this.projectKind$1.sampleDataManager().searchSampleDataFolderFor(currentVFPreview.getNameIdentifier()).map((Function1 & Serializable & scala.Serializable)scenarioFolder -> {
                        $anon$3.$anonfun$onFileChanged$2(this, uri, currentVFPreview, scenarioFolder);
                        return BoxedUnit.UNIT;
                    }));
                }
            }

            public static final /* synthetic */ void $anonfun$onFileChanged$2($anon$3 $this, String uri$1, VirtualFile currentVFPreview$1, File scenarioFolder) {
                block0: {
                    if (!URLUtils$.MODULE$.isChildOf(uri$1, scenarioFolder) && !URLUtils$.MODULE$.isChildOf(URLUtils$.MODULE$.toLSPUrl(scenarioFolder.getPath()), uri$1)) break block0;
                    $this.$outer.scheduleRunPreview(currentVFPreview$1);
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.projectKind$1 = projectKind$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$onFileChanged$1(org.mule.weave.lsp.services.PreviewService$$anon$3 java.lang.String org.mule.weave.v2.editor.VirtualFile ), $anonfun$onFileChanged$2$adapted(org.mule.weave.lsp.services.PreviewService$$anon$3 java.lang.String org.mule.weave.v2.editor.VirtualFile java.io.File )}, serializedLambda);
            }
        });
        eventBus.register(ProjectStartedEvent$.MODULE$.PROJECT_STARTED(), new OnProjectStarted(this){
            private final /* synthetic */ PreviewService $outer;

            public void onProjectStarted(Project project) {
                block0: {
                    if (!this.$outer.org$mule$weave$lsp$services$PreviewService$$pendingProjectStart().isDefined()) break block0;
                    this.$outer.scheduleRunPreview((VirtualFile)this.$outer.org$mule$weave$lsp$services$PreviewService$$pendingProjectStart().get());
                    this.$outer.org$mule$weave$lsp$services$PreviewService$$pendingProjectStart_$eq((Option<VirtualFile>)None$.MODULE$);
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        eventBus.register(ActiveScenarioChangedEvent$.MODULE$.ACTIVE_SCENARIO_CHANGED(), new OnActiveScenarioChanged(this){
            private final /* synthetic */ PreviewService $outer;

            public void onActiveScenarioChanged(VirtualFile vf) {
                block0: {
                    if (!this.$outer.org$mule$weave$lsp$services$PreviewService$$enableValue() || !this.$outer.org$mule$weave$lsp$services$PreviewService$$currentVfPreview().isDefined() || !((VirtualFile)this.$outer.org$mule$weave$lsp$services$PreviewService$$currentVfPreview().get()).url().equals(vf.url()) || !this.$outer.canRunPreview(vf)) break block0;
                    this.$outer.scheduleRunPreview(vf);
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public PreviewResult runPreview(VirtualFile vf) {
        PreviewResult previewResult;
        String fileUrl = vf.url();
        if (!this.project.isStarted()) {
            String x$1 = fileUrl;
            boolean x$2 = false;
            List<String> x$3 = Collections.emptyList();
            String x$4 = "Project is not yet initialized.\nPreview is going to be executed once project initializes.";
            String x$5 = PreviewResult$.MODULE$.apply$default$4();
            String x$6 = PreviewResult$.MODULE$.apply$default$5();
            String x$7 = PreviewResult$.MODULE$.apply$default$7();
            String x$8 = PreviewResult$.MODULE$.apply$default$8();
            long x$9 = PreviewResult$.MODULE$.apply$default$9();
            previewResult = new PreviewResult(x$1, x$2, x$3, x$5, x$6, x$4, x$7, x$8, x$9);
        } else {
            NameIdentifier identifier = vf.getNameIdentifier();
            String content = vf.read();
            this.logger().info(new StringBuilder(27).append("Trigger run preview for `").append(identifier).append("`.").toString());
            previewResult = this.agentService.run(identifier, content, fileUrl);
        }
        return previewResult;
    }

    public boolean canRunPreview(WeaveDocumentToolingService documentToolingService) {
        return documentToolingService == null ? false : this.canRunPreview(documentToolingService.file(), (Function0<Option<String>>)(Function0 & Serializable & scala.Serializable)() -> this.fileKind(documentToolingService));
    }

    public boolean canRunPreview(VirtualFile vf) {
        return this.canRunPreview(vf, (Function0<Option<String>>)(Function0 & Serializable & scala.Serializable)() -> this.fileKind(vf.url()));
    }

    private boolean canRunPreview(VirtualFile vf, Function0<Option<String>> fileKindResolver) {
        boolean bl;
        if (vf == null) {
            bl = false;
        } else {
            Option<URI> fileUrl = URLUtils$.MODULE$.toURI(vf.url());
            if (fileUrl.exists((Function1 & Serializable & scala.Serializable)p -> BoxesRunTime.boxToBoolean((boolean)PreviewService.$anonfun$canRunPreview$3(this, p)))) {
                bl = false;
            } else {
                Option mayBeKind = (Option)fileKindResolver.apply();
                boolean isMapping = mayBeKind.forall((Function1 & Serializable & scala.Serializable)kind -> BoxesRunTime.boxToBoolean((boolean)kind.equals(WeaveASTQueryUtils$.MODULE$.MAPPING())));
                bl = !vf.readOnly() && isMapping;
            }
        }
        return bl;
    }

    private Option<String> fileKind(String fileUrl) {
        return this.fileKind(this.toolingServices.openDocument(fileUrl, this.toolingServices.openDocument$default$2()));
    }

    /*
     * WARNING - void declaration
     */
    private Option<String> fileKind(WeaveDocumentToolingService documentToolingService) {
        void var3_3;
        Option maybeAstNode = documentToolingService.ast();
        Option<String> mayBeKind = WeaveASTQueryUtils$.MODULE$.fileKind((Option<AstNode>)maybeAstNode);
        return var3_3;
    }

    public void scheduleRunPreview(VirtualFile vf) {
        String fileUrl = vf.url();
        if (!this.canRunPreview(vf)) {
            String x$1 = fileUrl;
            boolean x$2 = false;
            List<String> x$3 = Collections.emptyList();
            String x$4 = new StringBuilder(42).append("File `").append(vf.getNameIdentifier().name()).append("` is not an executable mapping file.").toString();
            String x$5 = PreviewResult$.MODULE$.apply$default$4();
            String x$6 = PreviewResult$.MODULE$.apply$default$5();
            String x$7 = PreviewResult$.MODULE$.apply$default$7();
            String x$8 = PreviewResult$.MODULE$.apply$default$8();
            long x$9 = PreviewResult$.MODULE$.apply$default$9();
            this.weaveLanguageClient.showPreviewResult(new PreviewResult(x$1, x$2, x$3, x$5, x$6, x$4, x$7, x$8, x$9));
        } else if (!this.project.isStarted()) {
            this.org$mule$weave$lsp$services$PreviewService$$pendingProjectStart_$eq((Option<VirtualFile>)new Some((Object)vf));
            this.weaveLanguageClient.showPreviewResult(this.runPreview(vf));
        } else {
            NameIdentifier identifier = vf.getNameIdentifier();
            this.previewDebouncer().debounce(identifier, () -> $this.jobManager.execute(x$1 -> $this.weaveLanguageClient.showPreviewResult(this.runPreview(vf)), "Running preview", new StringBuilder(19).append("Running preview of ").append(identifier).toString()), 300L, TimeUnit.MILLISECONDS);
        }
        this.org$mule$weave$lsp$services$PreviewService$$currentVfPreview_$eq((Option<VirtualFile>)new Some((Object)vf));
    }

    public void enable() {
        this.org$mule$weave$lsp$services$PreviewService$$enableValue_$eq(true);
    }

    public void disable() {
        this.org$mule$weave$lsp$services$PreviewService$$enableValue_$eq(false);
        this.org$mule$weave$lsp$services$PreviewService$$currentVfPreview_$eq((Option<VirtualFile>)None$.MODULE$);
    }

    public static final /* synthetic */ boolean $anonfun$canRunPreview$3(PreviewService $this, URI p) {
        String string = p.getScheme();
        String string2 = $this.previewScheme;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public PreviewService(WeaveAgentService agentService, WeaveLanguageClient weaveLanguageClient, Project project, DataWeaveToolingService toolingServices, JobManagerService jobManager, String previewScheme) {
        this.agentService = agentService;
        this.weaveLanguageClient = weaveLanguageClient;
        this.project = project;
        this.toolingServices = toolingServices;
        this.jobManager = jobManager;
        this.previewScheme = previewScheme;
        ToolingService.$init$(this);
        this.logger = Logger.getLogger(this.getClass().getName());
        this.org$mule$weave$lsp$services$PreviewService$$enableValue = false;
        this.org$mule$weave$lsp$services$PreviewService$$pendingProjectStart = None$.MODULE$;
        this.org$mule$weave$lsp$services$PreviewService$$currentVfPreview = None$.MODULE$;
        this.previewDebouncer = new Debouncer();
    }
}

