package org.mule.weave.lsp.services.events

import org.mule.weave.lsp.services.events.AgentStartedEvent.AGENT_STARTED
import org.mule.weave.lsp.utils.Event
import org.mule.weave.lsp.utils.EventHandler
import org.mule.weave.lsp.utils.EventType

class AgentStartedEvent() extends Event {
  override type T = OnAgentStarted

  override def getType: EventType[OnAgentStarted] = AGENT_STARTED

  override def dispatch(handler: OnAgentStarted): Unit = {
    handler.onAgentStarted()
  }
}

trait OnAgentStarted extends EventHandler {
  def onAgentStarted(): Unit
}

object AgentStartedEvent {
  val AGENT_STARTED = EventType[OnAgentStarted]("AGENT_STARTED")
}