package org.mule.weave.lsp.actions

import org.eclipse.lsp4j.CodeAction
import org.eclipse.lsp4j.CodeActionParams
import org.mule.weave.lsp.commands.CommandProvider
import org.mule.weave.lsp.commands.InsertDocumentationCommand
import org.mule.weave.lsp.project.components.ContextMetadata
import org.mule.weave.lsp.services.DataWeaveToolingService
import org.mule.weave.v2.parser.ast.AstNode
import org.mule.weave.v2.parser.ast.header.directives.FunctionDirectiveNode
import org.mule.weave.v2.parser.ast.variables.NameIdentifier

class InsertDocumentationAction(toolingService: DataWeaveToolingService, commandProvider: CommandProvider) extends CodeActionProvider {
  
  override def doHandles(params: CodeActionParams, maybeContext: Option[ContextMetadata]): Boolean = {
    val documentToolingService = toolingService.openDocument(params.getTextDocument.getUri, maybeContext, withExpectedOutput = true)
    val maybeFunctionNode: Option[AstNode] = documentToolingService.nodeAt(params.getRange.getStart.getLine, params.getRange.getStart.getCharacter, Some(classOf[FunctionDirectiveNode]))
    val cursorOnNameIdentifier: Option[AstNode] = documentToolingService.nodeAt(params.getRange.getStart.getLine, params.getRange.getStart.getCharacter, Some(classOf[NameIdentifier]))
    //We only allow this action to be available on a function directive name
    maybeFunctionNode.exists(_.isInstanceOf[FunctionDirectiveNode]) &&
      cursorOnNameIdentifier.contains(maybeFunctionNode.get.asInstanceOf[FunctionDirectiveNode].nameIdentifier) &&
      maybeFunctionNode.exists(astNode => !astNode.hasWeaveDoc)
  }

  override def doActions(params: CodeActionParams, maybeContext: Option[ContextMetadata]): Array[CodeAction] = {
    val documentToolingService = toolingService.openDocument(params.getTextDocument.getUri, maybeContext, withExpectedOutput = true)
    val maybeNode = documentToolingService.nodeAt(params.getRange.getStart.getLine, params.getRange.getStart.getCharacter, Some(classOf[FunctionDirectiveNode]))
    val codeAction = new CodeAction(InsertDocumentationCommand.LABEL)
    val astNode = maybeNode.get
    codeAction.setCommand(InsertDocumentationCommand.createCommand(params.getTextDocument.getUri, astNode, commandProvider))
    Array(codeAction)
  }
}
