package org.mule.weave.lsp.commands

import org.eclipse.lsp4j.ExecuteCommandParams
import org.mule.weave.lsp.bat.BatProjectHelper
import org.mule.weave.lsp.bat.BatUserMessages
import org.mule.weave.lsp.extension.client.WeaveLanguageClient
import org.mule.weave.lsp.project.ProjectKind
import org.mule.weave.lsp.services.ClientLogger

import scala.collection.JavaConverters._

class RunBatFolderTestCommand(cl: ClientLogger, projectKind: ProjectKind, languageClient: WeaveLanguageClient) extends BatCommand(projectKind) {
  override def commandId(): String = Commands.BAT_RUN_BAT_FOLDER

  override def execute(params: ExecuteCommandParams): AnyRef = {
    val arguments = params.getArguments.asScala
    val batProjectManager = new BatProjectHelper(cl)
    if (installCLIIfNeeded(batProjectManager, languageClient)) {
      batProjectManager.run(arguments.head.toString, None)
    } else {
      languageClient.showMessage(BatUserMessages.batCLINotFound())
      ""
    }
  }


  override def name(): String = "Runs BAT Tests."

  override def description(params: ExecuteCommandParams): String = "Running all Bat Tests inside folder."

}
