package org.mule.weave.lsp.commands

import org.eclipse.lsp4j.Command
import org.eclipse.lsp4j.ExecuteCommandParams
import org.eclipse.lsp4j.MessageParams
import org.eclipse.lsp4j.MessageType
import org.eclipse.lsp4j.services.LanguageClient
import org.mule.weave.lsp.commands.Commands.argAsString
import org.mule.weave.lsp.services.PreviewService
import org.mule.weave.v2.editor.VirtualFile
import org.mule.weave.v2.editor.VirtualFileSystem

import java.util

class RunPreviewCommand(previewService: PreviewService, virtualFile: VirtualFileSystem, languageClient: LanguageClient) extends WeaveCommand {
  override def commandId(): String = Commands.DW_RUN_PREVIEW

  override def execute(params: ExecuteCommandParams): AnyRef = {
    val uri = argAsString(params.getArguments, 0)
    val file: VirtualFile = virtualFile.file(uri)
    if (file != null) {
      previewService.scheduleRunPreview(file)
    } else {
      languageClient.showMessage(new MessageParams(MessageType.Warning, s"Unable to run preview because file `$uri` was not found."))
    }
    null
  }

  override def name(): String = "Runs Preview."

  override def description(params: ExecuteCommandParams): String = "Running Preview."

  override def enabled(vf: VirtualFile): Boolean = previewService.canRunPreview(vf)
}

object RunPreviewCommand {
  val LABEL: String = "Run Preview"
  
  def createCommand(uri: String, commandProvider: CommandProvider): Command = {
    new Command(LABEL, 
      commandProvider.prefixCommandBaseId(Commands.DW_RUN_PREVIEW),
      util.Arrays.asList(uri)
    )
  }
} 
