package org.mule.weave.lsp.services

import org.mule.weave.lsp.agent.WeaveAgentService
import org.mule.weave.lsp.project.ProjectKind
import org.mule.weave.lsp.services.events.AgentStartedEvent
import org.mule.weave.lsp.services.events.OnAgentStarted
import org.mule.weave.lsp.utils.EventBus
import org.mule.weave.v2.agent.api.event.WeaveDataFormatProperty
import org.mule.weave.v2.completion.DataFormatDescriptor
import org.mule.weave.v2.completion.DataFormatDescriptorProvider
import org.mule.weave.v2.completion.DataFormatProperty

class AgentBasedDataFormatDescriptorProviderService(agentService: WeaveAgentService) extends DataFormatDescriptorProvider with ToolingService {
  var descriptors: Array[DataFormatDescriptor] = _

  override def init(projectKind: ProjectKind, eventBus: EventBus): Unit = {
    eventBus.register(AgentStartedEvent.AGENT_STARTED, new OnAgentStarted {
      override def onAgentStarted(): Unit = {
        updateProperties()
      }
    })

  }

  private def updateProperties(): Unit = {
    descriptors = agentService.dataFormats().map((dfd) => {
      DataFormatDescriptor(dfd.mimeType, dfd.id, toToolingProperties(dfd.writerProperties), toToolingProperties(dfd.readerProperties))
    })
  }

  private def toToolingProperties(writerProperties: Array[WeaveDataFormatProperty]): Array[DataFormatProperty] = {
    writerProperties.map((wp) => {
      DataFormatProperty(wp.name, wp.description, wp.wtype, wp.values)
    })
  }

  override def dataFormats(): Array[DataFormatDescriptor] = {
    if (descriptors == null || descriptors.length == 0) {
      updateProperties()
    }
    descriptors
  }

}
