package org.mule.weave.lsp.vfs.events

import org.mule.weave.lsp.utils.Event
import org.mule.weave.lsp.utils.EventHandler
import org.mule.weave.lsp.utils.EventType
import org.mule.weave.lsp.vfs.ArtifactVirtualFileSystem
import org.mule.weave.lsp.vfs.events.LibrariesRemovedEvent.LIBRARIES_REMOVED

class LibrariesRemovedEvent(libraries: Array[ArtifactVirtualFileSystem]) extends Event {
  override type T = OnLibrariesRemoved

  override def getType: EventType[OnLibrariesRemoved] = {
    LIBRARIES_REMOVED
  }

  override def dispatch(handler: OnLibrariesRemoved): Unit = {
    handler.onLibrariesRemoved(libraries)
  }
}

object LibrariesRemovedEvent {
  val LIBRARIES_REMOVED: EventType[OnLibrariesRemoved] = EventType[OnLibrariesRemoved]("LIBRARY_REMOVED")
}

trait OnLibrariesRemoved extends EventHandler {
  def onLibrariesRemoved(libraries: Array[ArtifactVirtualFileSystem])
}
