package org.mule.weave.lsp.vfs.events

import org.mule.weave.lsp.utils.Event
import org.mule.weave.lsp.utils.EventHandler
import org.mule.weave.lsp.utils.EventType
import org.mule.weave.lsp.vfs.events.ProjectVirtualFileCreatedEvent.VIRTUAL_FILE_CREATED
import org.mule.weave.v2.editor.VirtualFile

class ProjectVirtualFileCreatedEvent(vf: VirtualFile) extends Event {

  override type T = OnProjectVirtualFileCreatedEvent
  
  override def getType: EventType[OnProjectVirtualFileCreatedEvent] = VIRTUAL_FILE_CREATED

  override def dispatch(handler: OnProjectVirtualFileCreatedEvent): Unit = {
    handler.onVirtualFileCreated(vf)
  }
}


object ProjectVirtualFileCreatedEvent {
  val VIRTUAL_FILE_CREATED: EventType[OnProjectVirtualFileCreatedEvent] = EventType[OnProjectVirtualFileCreatedEvent]("VIRTUAL_FILE_CREATED")
}

trait OnProjectVirtualFileCreatedEvent extends EventHandler {
  def onVirtualFileCreated(vf: VirtualFile)
}