package org.mule.weave.lsp.indexer.events

import org.mule.weave.lsp.indexer.events.IndexingStartedEvent.INDEXING_STARTED
import org.mule.weave.lsp.indexer.events.IndexingType.IndexingType
import org.mule.weave.lsp.utils.Event
import org.mule.weave.lsp.utils.EventHandler
import org.mule.weave.lsp.utils.EventType

class IndexingStartedEvent(indexingType: IndexingType) extends Event {
  override type T = OnIndexingStarted

  override def getType: EventType[OnIndexingStarted] = {
    INDEXING_STARTED
  }

  override def dispatch(handler: OnIndexingStarted): Unit = {
    handler.onIndexingStarted(indexingType)
  }
}

object IndexingStartedEvent {
  val INDEXING_STARTED: EventType[OnIndexingStarted] = EventType[OnIndexingStarted]("INDEXING_STARTED")
}

trait OnIndexingStarted extends EventHandler {
  def onIndexingStarted(indexingType: IndexingType)
}
