package org.mule.weave.lsp.vfs.events

import org.mule.weave.lsp.utils.Event
import org.mule.weave.lsp.utils.EventHandler
import org.mule.weave.lsp.utils.EventType
import org.mule.weave.lsp.vfs.ArtifactVirtualFileSystem
import org.mule.weave.lsp.vfs.events.LibrariesAddedEvent.LIBRARIES_ADDED

class LibrariesAddedEvent(libraries: Array[ArtifactVirtualFileSystem]) extends Event {
  override type T = OnLibrariesAdded

  override def getType: EventType[OnLibrariesAdded] = {
    LIBRARIES_ADDED
  }

  override def dispatch(handler: OnLibrariesAdded): Unit = {
    handler.onLibrariesAdded(libraries)
  }
}

object LibrariesAddedEvent {
  val LIBRARIES_ADDED: EventType[OnLibrariesAdded] = EventType[OnLibrariesAdded]("LIBRARY_ADDED")
}

trait OnLibrariesAdded extends EventHandler {
  def onLibrariesAdded(vfs: Array[ArtifactVirtualFileSystem])
}
