package org.mule.weave.lsp.commands

import org.eclipse.lsp4j.ExecuteCommandParams
import org.mule.weave.lsp.extension.client.OpenTextDocumentParams
import org.mule.weave.lsp.extension.client.WeaveInputBoxParams
import org.mule.weave.lsp.extension.client.WeaveInputBoxResult
import org.mule.weave.lsp.extension.client.WeaveLanguageClient
import org.mule.weave.lsp.services.WeaveScenarioManagerService
import org.mule.weave.lsp.utils.URLUtils.toLSPUrl
import org.mule.weave.lsp.utils.WeaveDirectoryUtils
import org.mule.weave.v2.parser.ast.variables.NameIdentifier

class CreateScenarioCommand(weaveLanguageClient: WeaveLanguageClient, scenariosManager: WeaveScenarioManagerService) extends WeaveCommand {

  override def commandId(): String = Commands.DW_CREATE_SCENARIO

  override def execute(params: ExecuteCommandParams): AnyRef = {
    val nameIdentifier: String = Commands.argAsString(params.getArguments, 0)
    val mayBeScenarioName: Option[String] = Commands.optionalArgAsString(params.getArguments, 1)

    if (mayBeScenarioName.isDefined) {
      doCreateScenario(nameIdentifier, mayBeScenarioName.get)
    } else {
      val nameOfTheScenario: WeaveInputBoxResult = weaveLanguageClient.weaveInputBox(WeaveInputBoxParams(value = "NewTestScenario", title = "Specify the name of the Scenario")).get()
      if (!nameOfTheScenario.cancelled) {
        doCreateScenario(nameIdentifier, nameOfTheScenario.value)
      }
    }
    null
  }

  private def doCreateScenario(nameIdentifier: String, nameOfTheScenario: String): Unit = {
    val sampleName = weaveLanguageClient.weaveInputBox(WeaveInputBoxParams(title = "Specify The Sample Name", value = WeaveScenarioManagerService.DEFAULT_INPUT, prompt = "Name of sample i.e payload.json or vars.foo.csv")).get()
    if (!sampleName.cancelled) {
      val maybeFile = scenariosManager.createScenario(NameIdentifier(nameIdentifier), nameOfTheScenario, sampleName.value)
      if (maybeFile.isDefined) {
        weaveLanguageClient.openTextDocument(OpenTextDocumentParams(toLSPUrl(maybeFile.get)))
      }
    }
  }

  override def name(): String = "Create Scenario."

  override def description(params: ExecuteCommandParams): String = "Creating Scenario."
}
