package org.mule.weave.lsp.commands

import org.eclipse.lsp4j.ExecuteCommandParams
import org.mule.weave.lsp.bat.BatProjectHelper
import org.mule.weave.lsp.bat.BatUserMessages
import org.mule.weave.lsp.extension.client.WeaveLanguageClient
import org.mule.weave.lsp.project.ProjectKind
import org.mule.weave.lsp.services.ClientLogger
import org.mule.weave.lsp.services.DataWeaveToolingService
import org.mule.weave.lsp.utils.WeaveASTQueryUtils
import org.mule.weave.v2.editor.VirtualFile

import scala.collection.JavaConverters._
import scala.collection.mutable

class RunBatTestCommand(cl: ClientLogger, projectKind: ProjectKind, toolingService: DataWeaveToolingService, languageClient: WeaveLanguageClient) extends BatCommand(projectKind) {
  override def commandId(): String = Commands.BAT_RUN_BAT_TEST

  override def execute(params: ExecuteCommandParams): AnyRef = {
    val arguments: mutable.Seq[AnyRef] = params.getArguments.asScala
    val batProjectManager = new BatProjectHelper(cl)
    if (installCLIIfNeeded(batProjectManager, languageClient)) {
      batProjectManager.run(arguments.head.toString, arguments.tail.headOption.map(_.toString))
    } else {
      languageClient.showMessage(BatUserMessages.batCLINotFound())
      ""
    }
  }

  override def name(): String = "Run a single Bat Test."

  override def description(params: ExecuteCommandParams): String = "Running a Bat Test."

  override def enabled(vf: VirtualFile): Boolean = {
    super.enabled(vf) && WeaveASTQueryUtils.fileKind(toolingService.openDocument(vf.url()).ast()).exists(kind => WeaveASTQueryUtils.BAT.equals(kind))
  }
}
