package org.mule.weave.lsp.actions

import org.eclipse.lsp4j.CodeAction
import org.eclipse.lsp4j.CodeActionParams
import org.mule.weave.lsp.project.components.ContextMetadata

import java.util.logging.Level
import java.util.logging.Logger
import scala.util.Failure
import scala.util.Success
import scala.util.Try

abstract class CodeActionProvider {
  
  val logger: Logger = Logger.getLogger(getClass.getName)
  
  def handles(params: CodeActionParams, maybeContext: Option[ContextMetadata]): Boolean = {
    Try(doHandles(params, maybeContext)) match {
      case Success(value) => value
      case Failure(e) =>
        logger.log(Level.SEVERE, "Could not handle code action.", e)
        false
    }
  }

  def doHandles(params: CodeActionParams, maybeContext: Option[ContextMetadata]): Boolean

  def actions(params: CodeActionParams, maybeContext: Option[ContextMetadata]): Array[CodeAction] = {
    Try(doActions(params, maybeContext)) match {
      case Success(value) => value
      case Failure(e) =>
        logger.log(Level.SEVERE, "Could get code action.", e)
        Array.empty
    }
  }
  
  def doActions(params: CodeActionParams, maybeContextMetadata: Option[ContextMetadata]): Array[CodeAction]
}
