package org.mule.weave.lsp.actions

import org.eclipse.lsp4j.CodeAction
import org.eclipse.lsp4j.CodeActionParams
import org.mule.weave.lsp.commands.CommandProvider
import org.mule.weave.lsp.commands.InsertWeaveTypeCommand
import org.mule.weave.lsp.project.components.ContextMetadata
import org.mule.weave.lsp.services.DataWeaveToolingService
import org.mule.weave.v2.parser.ast.functions.FunctionNode
import org.mule.weave.v2.parser.ast.header.directives.FunctionDirectiveNode
import org.mule.weave.v2.parser.ast.header.directives.InputDirective
import org.mule.weave.v2.parser.ast.header.directives.VarDirective
import org.mule.weave.v2.parser.ast.variables.NameIdentifier

class InsertWeaveTypeAction(toolingService: DataWeaveToolingService, commandProvider: CommandProvider) extends CodeActionProvider {
  
  override def doHandles(params: CodeActionParams, maybeContext: Option[ContextMetadata]): Boolean = {
    val documentToolingService = toolingService.openDocument(params.getTextDocument.getUri, maybeContext, withExpectedOutput = true)
    documentToolingService 
      .nodeAt(params.getRange.getStart.getLine, params.getRange.getStart.getCharacter, Some(classOf[FunctionDirectiveNode]))
      .orElse({
        documentToolingService.nodeAt(params.getRange.getStart.getLine, params.getRange.getStart.getCharacter, Some(classOf[VarDirective]))
      })
      .orElse({
        documentToolingService.nodeAt(params.getRange.getStart.getLine, params.getRange.getStart.getCharacter, Some(classOf[InputDirective]))
      })
      .collect({
        case functionDirectiveNode: FunctionDirectiveNode => functionDirectiveNode.literal
        case varDirective: VarDirective => varDirective
        case varDirective: InputDirective => varDirective
      })
      .exists(astNode => {
        astNode match {
          case fn: FunctionNode => fn.returnType.isEmpty
          case vd: VarDirective => vd.wtype.isEmpty
          case id: InputDirective => id.wtype.isEmpty
          case _ => false
        }
      })
  }

  override def doActions(params: CodeActionParams, maybeContext: Option[ContextMetadata]): Array[CodeAction] = {
    val documentToolingService = toolingService.openDocument(params.getTextDocument.getUri, maybeContext, withExpectedOutput = true)
    val maybeNode = documentToolingService.nodeAt(params.getRange.getStart.getLine, params.getRange.getStart.getCharacter, Some(classOf[NameIdentifier]))
    val codeAction = new CodeAction("Add Type Annotation")
    maybeNode match {
      case Some(astNode: NameIdentifier) =>
        codeAction.setCommand(InsertWeaveTypeCommand.createCommand(params.getTextDocument.getUri, astNode, commandProvider))
        Array(codeAction)
      case _ =>
        Array.empty
    }

  }
}
