package org.mule.weave.lsp.project.commands

import java.io.FileWriter
import java.io.PrintWriter
import java.nio.file.Files
import java.nio.file.Path
import scala.io.Source._


class DefaultProjectCreator() extends ProjectCreator {

  def create(projectInfo: ProjectCreationInfo): Unit = {
    val source = fromResource("pom-default.xml")
    val projectPath = projectInfo.pathToCreate.resolve(projectInfo.projectName)
    Files.createDirectories(projectPath)
    val finalPomFile = projectPath.resolve("pom.xml").toFile // Temporary File
    val replacedPom = source.mkString
      .replaceAll("@group-id@", projectInfo.groupId)
      .replaceAll("@artifact-id@", projectInfo.artifactId)
      .replaceAll("@version@", projectInfo.version)
      .replaceAll("@project-name@", projectInfo.projectName)
    new PrintWriter(finalPomFile) {
      write(replacedPom);
      close
    }
    val sourcePath = projectPath.resolve("src")
    val mainPath = sourcePath.resolve("main")
    val mainDwPath = mainPath.resolve("dw")
    val dwModulePath = mainDwPath.resolve("MyModule.dwl")
    val mainResourcesPath = mainPath.resolve("resources")
    val testPath = sourcePath.resolve("test")
    val testDwPath = testPath.resolve("dw")
    val dwMappingPath = testDwPath.resolve("MyMapping.dwl")
    val testResourcesPath = testPath.resolve("resources")

    Files.createDirectories(mainDwPath)
    Files.createDirectories(mainResourcesPath)
    Files.createDirectories(testDwPath)
    Files.createDirectories(testResourcesPath)

    val exampleDwModule = fromResource("dw-template-project-module.dwl").mkString
    val exampleDwMapping = fromResource("dw-template-project-mapping.dwl").mkString

    writeFile(dwModulePath, exampleDwModule)
    writeFile(dwMappingPath, exampleDwMapping)
  }

  private def writeFile(p: Path, content: String): Unit = {
    val file = p.toFile

    new FileWriter(file) {
      write(content)
      close()
    }
  }
}

trait ProjectCreator {

  def create(projectInfo: ProjectCreationInfo)
}

case class ProjectCreationInfo(var groupId: String = "", var artifactId: String = "", var version: String = "", var projectName: String = "", var pathToCreate: Path = null)
