package org.mule.weave.lsp.project.components

import org.jboss.shrinkwrap.resolver.api.maven.coordinate.MavenCoordinates
import org.mule.weave.lsp.extension.services.ArtifactDefinition

import java.io.File

/**
  * Handles the artifact resolution and download of all the project dependencies.
  */
trait ProjectDependencyManager {

  /**
    *
    * @return
    */
  def languageLevel(): String

  /**
    * Starts the dependency manager
    */
  def start(): Unit

  def reload(): Unit

  /**
    * Returns the list of all the dependencies
    *
    * @return
    */
  def dependencies(): Array[DependencyArtifact]

  def addDependency(artifact: ArtifactDefinition): Unit = {}

  def removeDependency(artifact: ArtifactDefinition): Unit = {}

  def getDependencies(
                       groupId: Option[String] = None,
                       artifactId: Option[String] = None,
                       version: Option[String] = None,
                       classifier: Option[String] = None
                     ): Array[DependencyArtifact] = {
    dependencies()
      .filter(p => {
        val mavenGAV = MavenCoordinates.createCoordinate(p.artifactId)
        groupId.forall(_ == mavenGAV.getGroupId) &&
          artifactId.forall(_ == mavenGAV.getArtifactId) &&
          version.forall(_ == mavenGAV.getVersion) &&
          classifier.forall(_ == mavenGAV.getClassifier)
      })
  }

}

case class DependencyArtifact(artifactId: String, artifact: File)
