/*
 * Decompiled with CFR 0.152.
 */
package org.mule.weave.lsp.actions;

import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.CodeActionParams;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.mule.weave.lsp.actions.CodeActionProvider;
import org.mule.weave.lsp.commands.CommandProvider;
import org.mule.weave.lsp.commands.ExtractConstantCommand$;
import org.mule.weave.lsp.commands.ExtractFunctionCommand$;
import org.mule.weave.lsp.commands.ExtractVariableCommand$;
import org.mule.weave.lsp.project.components.ContextMetadata;
import org.mule.weave.lsp.services.DataWeaveToolingService;
import org.mule.weave.v2.editor.WeaveDocumentToolingService;
import org.mule.weave.v2.parser.ast.AstNode;
import org.mule.weave.v2.parser.ast.AstNodeHelper$;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001!4Aa\u0002\u0005\u0001'!A\u0001\u0004\u0001B\u0001B\u0003%\u0011\u0004\u0003\u0005 \u0001\t\u0005\t\u0015!\u0003!\u0011\u00151\u0003\u0001\"\u0001(\u0011\u0015Y\u0003\u0001\"\u0011-\u0011\u0015Q\u0005\u0001\"\u0003L\u0011\u0015q\u0006\u0001\"\u0011`\u0005Y\u0011VMZ1di>\u0014\u0018i\u0019;j_:\u0004&o\u001c<jI\u0016\u0014(BA\u0005\u000b\u0003\u001d\t7\r^5p]NT!a\u0003\u0007\u0002\u00071\u001c\bO\u0003\u0002\u000e\u001d\u0005)q/Z1wK*\u0011q\u0002E\u0001\u0005[VdWMC\u0001\u0012\u0003\ry'oZ\u0002\u0001'\t\u0001A\u0003\u0005\u0002\u0016-5\t\u0001\"\u0003\u0002\u0018\u0011\t\u00112i\u001c3f\u0003\u000e$\u0018n\u001c8Qe>4\u0018\u000eZ3s\u00039!xn\u001c7j]\u001e\u001cVM\u001d<jG\u0016\u0004\"AG\u000f\u000e\u0003mQ!\u0001\b\u0006\u0002\u0011M,'O^5dKNL!AH\u000e\u0003/\u0011\u000bG/Y,fCZ,Gk\\8mS:<7+\u001a:wS\u000e,\u0017aD2p[6\fg\u000e\u001a)s_ZLG-\u001a:\u0011\u0005\u0005\"S\"\u0001\u0012\u000b\u0005\rR\u0011\u0001C2p[6\fg\u000eZ:\n\u0005\u0015\u0012#aD\"p[6\fg\u000e\u001a)s_ZLG-\u001a:\u0002\rqJg.\u001b;?)\rA\u0013F\u000b\t\u0003+\u0001AQ\u0001G\u0002A\u0002eAQaH\u0002A\u0002\u0001\n\u0011\u0002Z8IC:$G.Z:\u0015\u00075\u001aT\b\u0005\u0002/c5\tqFC\u00011\u0003\u0015\u00198-\u00197b\u0013\t\u0011tFA\u0004C_>dW-\u00198\t\u000bQ\"\u0001\u0019A\u001b\u0002\rA\f'/Y7t!\t14(D\u00018\u0015\tA\u0014(A\u0003mgB$$N\u0003\u0002;!\u00059Qm\u00197jaN,\u0017B\u0001\u001f8\u0005A\u0019u\u000eZ3BGRLwN\u001c)be\u0006l7\u000fC\u0003?\t\u0001\u0007q(\u0001\u0007nCf\u0014WmQ8oi\u0016DH\u000fE\u0002/\u0001\nK!!Q\u0018\u0003\r=\u0003H/[8o!\t\u0019\u0005*D\u0001E\u0015\t)e)\u0001\u0006d_6\u0004xN\\3oiNT!a\u0012\u0006\u0002\u000fA\u0014xN[3di&\u0011\u0011\n\u0012\u0002\u0010\u0007>tG/\u001a=u\u001b\u0016$\u0018\rZ1uC\u0006AAo\\(gMN,G\u000fF\u0002M\u001ff\u0003\"AL'\n\u00059{#aA%oi\")\u0001+\u0002a\u0001#\u00061Bm\\2v[\u0016tG\u000fV8pY&twmU3sm&\u001cW\r\u0005\u0002S/6\t1K\u0003\u0002U+\u00061Q\rZ5u_JT!A\u0016\u0007\u0002\u0005Y\u0014\u0014B\u0001-T\u0005m9V-\u0019<f\t>\u001cW/\\3oiR{w\u000e\\5oON+'O^5dK\")!,\u0002a\u00017\u0006i1\u000f^1siB{7/\u001b;j_:\u0004\"A\u000e/\n\u0005u;$\u0001\u0003)pg&$\u0018n\u001c8\u0002\u0013\u0011|\u0017i\u0019;j_:\u001cHc\u00011gOB\u0019a&Y2\n\u0005\t|#!B!se\u0006L\bC\u0001\u001ce\u0013\t)wG\u0001\u0006D_\u0012,\u0017i\u0019;j_:DQ\u0001\u000e\u0004A\u0002UBQA\u0010\u0004A\u0002}\u0002")
public class RefactorActionProvider
extends CodeActionProvider {
    private final DataWeaveToolingService toolingService;
    private final CommandProvider commandProvider;

    @Override
    public boolean doHandles(CodeActionParams params, Option<ContextMetadata> maybeContext) {
        boolean bl;
        int endOffset;
        WeaveDocumentToolingService documentToolingService = this.toolingService.openDocument(params.getTextDocument().getUri(), maybeContext, true);
        Range range = params.getRange();
        Position startPosition = range.getStart();
        Position endPosition = range.getEnd();
        int startOffset = this.toOffset(documentToolingService, startPosition);
        Option maybeNode = documentToolingService.nodeAt(startOffset, endOffset = this.toOffset(documentToolingService, endPosition));
        Option option = maybeNode;
        if (option instanceof Some) {
            Some some = (Some)option;
            AstNode nodeToExtract = (AstNode)some.value();
            bl = AstNodeHelper$.MODULE$.isExpressionNode(nodeToExtract) || AstNodeHelper$.MODULE$.isWeaveTypeNode(nodeToExtract);
        } else if (None$.MODULE$.equals(option)) {
            bl = false;
        } else {
            throw new MatchError((Object)option);
        }
        return bl;
    }

    private int toOffset(WeaveDocumentToolingService documentToolingService, Position startPosition) {
        return documentToolingService.offsetOf(startPosition.getLine(), startPosition.getCharacter());
    }

    @Override
    public CodeAction[] doActions(CodeActionParams params, Option<ContextMetadata> maybeContext) {
        WeaveDocumentToolingService documentToolingService = this.toolingService.openDocument(params.getTextDocument().getUri(), maybeContext, true);
        Range range = params.getRange();
        Position startPosition = range.getStart();
        Position endPosition = range.getEnd();
        int startOffset = this.toOffset(documentToolingService, startPosition);
        int endOffset = this.toOffset(documentToolingService, endPosition);
        CodeAction extractVariable = new CodeAction("Extract Variable (Local Scope)");
        extractVariable.setCommand(ExtractVariableCommand$.MODULE$.createCommand(startOffset, endOffset, params.getTextDocument().getUri(), this.commandProvider));
        extractVariable.setKind("refactor.extract.variable");
        CodeAction extractConstant = new CodeAction("Extract Variable (Global Scope)");
        extractConstant.setCommand(ExtractConstantCommand$.MODULE$.createCommand(startOffset, endOffset, params.getTextDocument().getUri(), this.commandProvider));
        extractConstant.setKind("refactor.extract.constant");
        CodeAction extractFunction = new CodeAction("Extract Function");
        extractFunction.setCommand(ExtractFunctionCommand$.MODULE$.createCommand(startOffset, endOffset, params.getTextDocument().getUri(), this.commandProvider));
        extractFunction.setKind("refactor.extract.function");
        return (CodeAction[])((Object[])new CodeAction[]{extractVariable, extractConstant, extractFunction});
    }

    public RefactorActionProvider(DataWeaveToolingService toolingService, CommandProvider commandProvider) {
        this.toolingService = toolingService;
        this.commandProvider = commandProvider;
    }
}

