package org.mule.weave.extension.api.component.features;

import java.util.Objects;

public class Feature {
    private final String category;
    private final FeatureKind kind;

    public Feature(String category, FeatureKind kind) {
        this.category = category;
        this.kind = kind;
    }

    public FeatureKind kind() {
        return kind;
    }

    public String category() {
        return category;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (!(o instanceof Feature)) return false;
        Feature feature = (Feature) o;
        return kind == feature.kind && Objects.equals(category, feature.category);
    }

    @Override
    public int hashCode() {
        return Objects.hash(kind, category);
    }
}
