package org.mule.weave.extension.api.extension.validation;

import static java.util.Objects.requireNonNull;

import org.mule.weave.v2.api.tooling.ast.DWAstNode;

/**
 * Represents the document text URI and its {@link DWAstNode} root.
 */
public final class DocumentNode {
    private final String documentUri;
    private final DWAstNode rootAstNode;

    public DocumentNode(String documentUri, DWAstNode rootAstNode) {
        requireNonNull(documentUri, "'documentUri' cannot be null");
        requireNonNull(rootAstNode, "'rootAstNode' cannot be null");
        this.documentUri = documentUri;
        this.rootAstNode = rootAstNode;
    }

    public String documentUri() {
        return documentUri;
    }

    public DWAstNode rootAstNode() {
        return rootAstNode;
    }

}
