package org.mule.weave.extension.api.services.ast;

import org.eclipse.lsp4j.MarkupContent;
import org.eclipse.lsp4j.Range;
import org.mule.weave.extension.api.services.WeaveService;
import org.mule.weave.v2.api.tooling.ast.DWAstNode;
import org.mule.weave.v2.api.tooling.ast.DWAstNodeKind;

import java.util.Optional;

/**
 * DataWeave Service to retrieve {@link DWAstNode} from a uri project file.
 */
public interface AstNodeService extends WeaveService {

    /**
     * Given a {@link String} that references a project file URI and a {@link Range} for the given
     * {@link DWAstNodeKind}, it parses the script and generates the {@link DWAstNode} for the expected kind.
     * This method will apply the scope or type checking phases.
     *
     * @param uri file URI to be parsed.
     * @param range The range.
     * @return an {@link Optional} of {@link DWAstNode} if there is a node at the given location.
     */
    Optional<DWAstNode> nodeAt(String uri, Range range);

    /**
     * Given a weaveDoc it creates a {@link MarkupContent} in mark down format.
     *
     * @param weaveDoc The weave documentation to transform.
     * @return The created {@link MarkupContent} in mark down format.
     */
    MarkupContent toMarkupContent(String weaveDoc);
}
