package org.mule.weave.extension.api.project;

import org.mule.dx.platform.api.project.ProjectDescriptor;
import org.mule.dx.platform.api.project.ProjectDescriptorBuilder;

/**
 * The initializers will be called when a project is initializing, this enables different kind of components to setup its own natures
 * A nature describes a set of orthogonal capabilities that are going to be attached to the project. For example a nature called maven will contribute with
 * all the components related to maven (project structure, dependency management, label, name of the project). Other natures like connectivity or mule
 * can contribute with other capabilities such as indexers, custom commands and so.
 */
public interface ProjectInitializer {
    /**
     * If returns true
     *
     * @param projectMetadata The projectMetadata contains basic information about the project
     * @return if true the `initialize` will be called
     */
    boolean supports(ProjectMetadata projectMetadata);

    /**
     * Initialize the project is being called to set up the project
     *
     * @param projectMetadata The projectMetadata contains basic information about the project
     * @param builder         The builder to contribute to
     * @return The ProjectDescriptor bing built
     */
    ProjectDescriptor initialize(ProjectMetadata projectMetadata, ProjectDescriptorBuilder builder);

    /**
     *
     * @return the project kind name in lowercase
     */
    String getKind();
}
