/*
 * Decompiled with CFR 0.152.
 */
package org.mule.weave.extension.api.extension.annotations;

import java.util.Objects;
import org.mule.weave.extension.api.extension.annotations.WeaveAnnotationProcessorBinding;
import org.mule.weave.v2.api.tooling.annotation.DWAnnotationProcessor;
import org.mule.weave.v2.api.tooling.location.ResourceIdentifier;

public class DefaultWeaveAnnotationProcessorBinding
implements WeaveAnnotationProcessorBinding {
    private final ResourceIdentifier resourceIdentifier;
    private final DWAnnotationProcessor annotationProcessor;

    public DefaultWeaveAnnotationProcessorBinding(ResourceIdentifier resourceIdentifier, DWAnnotationProcessor annotationProcessor) {
        this.resourceIdentifier = resourceIdentifier;
        this.annotationProcessor = annotationProcessor;
    }

    @Override
    public ResourceIdentifier getResourceIdentifier() {
        return this.resourceIdentifier;
    }

    @Override
    public DWAnnotationProcessor getAnnotationProcessor() {
        return this.annotationProcessor;
    }

    static class Builder
    implements WeaveAnnotationProcessorBinding.Builder {
        private ResourceIdentifier resourceIdentifier;
        private DWAnnotationProcessor annotationProcessor;

        protected Builder() {
        }

        @Override
        public WeaveAnnotationProcessorBinding.Builder withResourceIdentifier(ResourceIdentifier resourceIdentifier) {
            Objects.requireNonNull(resourceIdentifier);
            this.resourceIdentifier = resourceIdentifier;
            return this;
        }

        @Override
        public WeaveAnnotationProcessorBinding.Builder withAnnotationProcessor(DWAnnotationProcessor annotationProcessor) {
            Objects.requireNonNull(annotationProcessor);
            this.annotationProcessor = annotationProcessor;
            return this;
        }

        @Override
        public WeaveAnnotationProcessorBinding build() {
            Objects.requireNonNull(this.resourceIdentifier, "ResourceIdentifier is required and not set.");
            Objects.requireNonNull(this.annotationProcessor, "DWAnnotationProcessor is required and not set.");
            return new DefaultWeaveAnnotationProcessorBinding(this.resourceIdentifier, this.annotationProcessor);
        }
    }
}

