package org.mule.weave.extension.api.llm.tools;

/**
 * Represents a Tool for an LLM
 */
public interface LLMTool {

    /**
     * The name of the tool to be executed
     *
     * @return The name of the tool
     */
    String name();

    /**
     * Returns an description of what the tool is going to do
     *
     * @return The description shown to the user
     */
    LLMToolDescription actionDescription();

    /**
     * The tool to execute
     *
     * @param params The parameters of the tool
     * @return The tool response
     */
    LLMToolResponse execute(LLMToolParams params);
}
