package org.mule.weave.extension.api.extension.action;

import org.eclipse.lsp4j.CodeActionParams;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.Range;
import org.mule.weave.extension.api.metadata.ContextMetadata;

import javax.annotation.Nullable;
import java.util.List;
import java.util.Optional;

/**
 * Base class for creating {@link org.eclipse.lsp4j.CodeAction} for quick fixes. It takes care of the checking
 * if there is a {@link Diagnostic} reported for the current location were the code action is requested.
 * Implementation that would like to contribute with code actions as quick fixes should extend from this class.
 */
public abstract class QuickFixCodeActionProvider implements WeaveCodeActionProvider {

    public final boolean handles(CodeActionParams params, @Nullable ContextMetadata context) {
        return getDiagnostic(params, params.getContext().getDiagnostics()).isPresent();
    }

    protected Optional<Diagnostic> getDiagnostic(CodeActionParams params, List<Diagnostic> diagnostics) {
        return diagnostics.stream()
                .filter(d -> getKind().equals(d.getCode().getLeft()) && contains(d.getRange(), params.getRange()))
                .findAny();
    }

    private boolean contains(Range range, Range cursorRange) {
        return cursorRange.getStart().getLine() >= range.getStart().getLine() &&
                cursorRange.getStart().getCharacter() >= range.getStart().getCharacter() &&
                cursorRange.getEnd().getLine() <= range.getEnd().getLine() &&
                cursorRange.getEnd().getCharacter() <= range.getEnd().getCharacter();
    }

    protected abstract String getKind();

}
