package org.mule.weave.extension.api.metadata;

import org.mule.weave.v2.api.tooling.ts.DWType;

import javax.annotation.Nullable;

public class ContextMetadata {

    private final InputMetadata inputMetadata;
    private final DWType output;

    public ContextMetadata() {
        this(null, null);
    }

    public ContextMetadata(InputMetadata inputMetadata) {
        this(inputMetadata, null);
    }

    public ContextMetadata(InputMetadata inputMetadata, DWType output) {
        this.inputMetadata = inputMetadata;
        this.output = output;
    }

    @Nullable
    public InputMetadata getInputMetadata() {
        return inputMetadata;
    }

    @Nullable
    public DWType getOutput() {
        return output;
    }
}
