package org.mule.weave.extension.api.component.dependency;

import java.io.File;
import java.util.Objects;

public class DependencyArtifact {

    private final String groupId;
    private final String artifactId;
    private final String packaging;
    private final String classifier;
    private final String version;
    private final File file;

    public DependencyArtifact(String groupId, String artifactId, String packaging, String classifier, String version, File file) {
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.packaging = packaging;
        this.classifier = classifier;
        this.version = version;
        this.file = file;
    }

    public String groupId() {
        return groupId;
    }

    public String artifactId() {
        return artifactId;
    }

    public String packaging() {
        return packaging;
    }

    public String classifier() {
        return classifier;
    }

    public String version() {
        return version;
    }

    public File file() {
        return file;
    }

    @Override
    public boolean equals(Object o) {
        if (o == null || getClass() != o.getClass()) return false;
        DependencyArtifact that = (DependencyArtifact) o;
        return Objects.equals(groupId, that.groupId) && Objects.equals(artifactId, that.artifactId) && Objects.equals(packaging, that.packaging) && Objects.equals(classifier, that.classifier) && Objects.equals(version, that.version) && Objects.equals(file, that.file);
    }

    @Override
    public int hashCode() {
        return Objects.hash(groupId, artifactId, packaging, classifier, version, file);
    }
}
