package org.mule.weave.extension.api.llm.tools;

import java.util.List;

/**
 * Represents the outcome of a {@link LLMTool} execution.
 * <p>
 * This record encapsulates the result, including any messages generated during
 * the tool's operation and a boolean flag indicating whether the execution
 * was successful.
 * </p>
 *
 * @param messages A list of strings containing messages from the tool's execution.
 *                 This could include informational messages, error details, or results.
 *                 The list will be empty if no messages were generated.
 * @param success  {@code true} if the tool executed successfully, {@code false} otherwise.
 *                 Indicates the overall status of the tool's operation.
 * @see LLMTool
 * @see LLMToolResponseBuilder
 */
public record LLMToolResponse(List<String> messages, boolean success) {
}
