package org.mule.weave.extension.api.component.metadata;

import org.mule.weave.extension.api.component.WeaveComponent;
import org.mule.weave.extension.api.filesystem.VirtualFile;
import org.mule.weave.extension.api.metadata.ContextMetadata;

import java.util.Optional;

public interface WeaveMetadataProviderComponent extends WeaveComponent {

    /**
     * Get the context metadata for the given virtual file.
     *
     * @param virtualFile The virtual File.
     * @return The context metadata for the given virtual file.
     */
    Optional<ContextMetadata> metadata(VirtualFile virtualFile);
}
