package org.mule.weave.extension.api.events;

import static org.mule.weave.extension.api.events.EventTypes.INDEXING_STARTED;

import org.mule.dx.platform.api.event.AbstractEvent;
import org.mule.weave.extension.api.project.ProjectMetadata;

public class IndexingStartedEvent extends AbstractEvent<IndexingStartedEventHandler> {
    private final ProjectMetadata projectMetadata;

    public IndexingStartedEvent(ProjectMetadata projectMetadata) {
        super(INDEXING_STARTED);
        this.projectMetadata = projectMetadata;
    }

    @Override
    public void dispatch(IndexingStartedEventHandler handler) {
        handler.onIndexingStarted(projectMetadata);
    }

}
