package org.mule.weave.extension.api.events;

import static org.mule.weave.extension.api.events.EventTypes.INDEXING_FINISHED;

import org.mule.dx.platform.api.event.AbstractEvent;
import org.mule.weave.extension.api.project.ProjectMetadata;

public class IndexingFinishedEvent extends AbstractEvent<IndexingFinishedEventHandler> {
    private final ProjectMetadata projectMetadata;

    public IndexingFinishedEvent(ProjectMetadata projectMetadata) {
        super(INDEXING_FINISHED);
        this.projectMetadata = projectMetadata;
    }

    @Override
    public void dispatch(IndexingFinishedEventHandler handler) {
        handler.onIndexingFinished(projectMetadata);
    }

}
