package org.mule.weave.extension.api.events;

import org.mule.dx.platform.api.event.AbstractEvent;
import org.mule.weave.extension.api.project.ProjectMetadata;

import static org.mule.weave.extension.api.events.EventTypes.PROJECT_STOPPED;

public class ProjectStoppedEvent extends AbstractEvent<ProjectStoppedEventHandler> {
    private final ProjectMetadata projectMetadata;

    public ProjectStoppedEvent(ProjectMetadata projectMetadata) {
        super(PROJECT_STOPPED);
        this.projectMetadata = projectMetadata;
    }

    @Override
    public void dispatch(ProjectStoppedEventHandler handler) {
        handler.onProjectStopped(projectMetadata);
    }
}
