package org.mule.weave.extension.api.extension.annotations;

import org.mule.weave.v2.api.tooling.annotation.DWAnnotationProcessor;
import org.mule.weave.v2.api.tooling.location.ResourceIdentifier;

/**
 * A binding to map a instance of a {@link DWAnnotationProcessor} to a {@link ResourceIdentifier} to be applied.
 */
public interface WeaveAnnotationProcessorBinding {

    /**
     * @return the {@link ResourceIdentifier} which identifies the unique resource where the annotation processor
     * will be executed to.
     */
    ResourceIdentifier getResourceIdentifier();

    /**
     * @return the {@link DWAnnotationProcessor} to be executed.
     */
    DWAnnotationProcessor getAnnotationProcessor();

    static Builder builder() {
        return new DefaultWeaveAnnotationProcessorBinding.Builder();
    }

    interface Builder {
        Builder withResourceIdentifier(ResourceIdentifier resourceIdentifier);

        Builder withAnnotationProcessor(DWAnnotationProcessor annotationProcessor);

        WeaveAnnotationProcessorBinding build();
    }

}
